package ru.yandex.chemodan.app.monops.cluster;

import lombok.Data;
import org.joda.time.Instant;
import org.joda.time.format.ISODateTimeFormat;

import ru.yandex.chemodan.util.bender.ISOInstantUnmarshaller;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.ReadableInstantConfigurableMarshaller;

/**
 * @author m-messiah
 */
public class DelayedCloseDCZkRegistry extends ZkRegistry<String, DelayedCloseDCZkRegistry.DelayedCloseDC> {
    public DelayedCloseDCZkRegistry(ZkPath path) {
        super(path, Bender.cons(DelayedCloseDC.class, BenderConfiguration.cons(
                MembersToBind.WITH_ANNOTATIONS, false,
                CustomMarshallerUnmarshallerFactoryBuilder.cons()
                        .add(Instant.class, new ReadableInstantConfigurableMarshaller(ISODateTimeFormat.dateTime()))
                        .add(Instant.class, new ISOInstantUnmarshaller())
                        .build())), DelayedCloseDC::getId, s -> s);
    }

    public void scheduleCloseDc(String dcName, Instant startTime, Boolean isDb) {
        put(new DelayedCloseDC(dcName, isDb, startTime));
    }

    public void cancelCloseDc(String dcName, Boolean isDb) {
        remove(new DelayedCloseDC(dcName, isDb, Instant.now()).getId());
    }

    @Data
    @BenderBindAllFields
    public static class DelayedCloseDC {
        public final String dcName;
        public final Boolean isDb;
        public final Instant startTime;

        public String getId() {
            return dcName + (isDb ? "-dbs" : "");
        }

        public boolean isBeforeNow() {
            return startTime.isBeforeNow();
        }
    }
}
