package ru.yandex.chemodan.app.monops.cluster;

import lombok.Data;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author m-messiah
 */
public class InfraEventsZkRegistry extends ZkRegistry<String, InfraEventsZkRegistry.DcEvent> {
    public InfraEventsZkRegistry(ZkPath path) {
        super(path, Bender.cons(InfraEventsZkRegistry.DcEvent.class), InfraEventsZkRegistry.DcEvent::getDcName, s -> s);
    }

    @Data
    @BenderBindAllFields
    public static class DcEvent {
        public final Integer id;
        public final String dcName;
    }
}
