package ru.yandex.chemodan.app.monops.cluster;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
@Data
@BenderBindAllFields
public class JugglerSelector {
    public final Option<String> host;
    public final Option<String> service;

    public JugglerSelector(String host) {
        this.host = Option.of(host);
        this.service = Option.empty();
    }

    public JugglerSelector(String host, String service) {
        this.host = Option.of(host);
        this.service = Option.ofNullable(StringUtils.trimToNull(service));
    }

    public static ListF<JugglerSelector> defaultSelectorsForApp(String app) {
        app = ApplicationInfo.simpleName(app);
        return Cf.list(
                new JugglerSelector("disk_" + app),
                new JugglerSelector(app + ".disk.yandex.net"),
                new JugglerSelector("disk_" + app + "_devops"),
                new JugglerSelector("disk_qloud_" + app),
                new JugglerSelector("disk_qloud_" + app + "_devops"),
                new JugglerSelector("disk-" + app + ".stage.disk-" + app + "-stable"),
                new JugglerSelector("disk-" + app + "-stable")
        );
    }

    public String toQuery() {
        return host.map(h -> "host=" + h).plus(service.map(s -> "service=" + s)).mkString(" & ");
    }
}
