package ru.yandex.chemodan.app.monops.cluster;

import lombok.Data;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author m-messiah
 */
public class ManagedAppsZkRegistry extends ZkRegistry<String, ManagedAppsZkRegistry.AppInfo> {

    public ManagedAppsZkRegistry(ZkPath path) {
        super(path, Bender.cons(AppInfo.class), AppInfo::getId, s -> s);
    }

    @Data
    @BenderBindAllFields
    public static class AppInfo {
        public final String id;
    }
}
