package ru.yandex.chemodan.app.monops.cluster;

import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.qloud.client.QloudComponentRuntime;
import ru.yandex.inside.qloud.client.QloudEnvironmentState;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
@Data
@Builder(toBuilder = true)
@AllArgsConstructor
@BenderBindAllFields
public class QloudCompactState {
    public final MapF<String, Integer> instancesByDc;
    public final MapF<String, String> componentVersions;
    public final String lastComment;
    public final Instant lastCreationDate;

    public QloudCompactState(QloudEnvironmentState qloudEnvironmentState, MapF<String, QloudComponentRuntime> runtimes) {
        instancesByDc = qloudEnvironmentState.components.values()
                .flatMap(cs -> cs.runningInstances.flatMap(instance -> {
                    return instance.line.map(line -> line.substring(0, 3).toLowerCase());
                })).groupBy(s -> s)
                .mapValues(List::size);

        componentVersions = runtimes.mapValues(runtime -> {
                    return runtime.sandboxResources
                            .find(resource -> resource.type.equals("DISK_COMPRESSED_RESOURCE_APPLICATION"))
                            .map(resource -> resource.description);
                }).filterValues(Option::isPresent)
                .mapValues(Option::get);

        lastComment = qloudEnvironmentState.comment;
        lastCreationDate = qloudEnvironmentState.creationDate;
    }
}
