package ru.yandex.chemodan.app.monops.cluster;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author tolmalev
 */
@Data
@Bendable
@BenderMembersToBind(MembersToBind.WITH_ANNOTATIONS)
public class UsefulLink implements UrlProvider {
    @BenderPart
    public final String url;
    @BenderPart
    public final Option<String> title;

    public UsefulLink(String url, String title) {
        this(url, Option.of(title));
    }

    public UsefulLink(String url, Option<String> title) {
        this.url = url;
        this.title = title;
    }
}
