package ru.yandex.chemodan.app.monops.worker;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.monops.awacs.AwacsBalancerManager;
import ru.yandex.chemodan.app.monops.cluster.DelayedCloseDCZkRegistry;
import ru.yandex.chemodan.dc.closing.ClosedDataCenterInfo;
import ru.yandex.chemodan.dc.closing.ClosedDataCenterZkRegistry;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

public class DelayedCloseController extends DelayingWorkerServiceBeanSupport {
    private static final Logger logger = LoggerFactory.getLogger(DelayedCloseController.class);
    private final ClosedDataCenterZkRegistry closedDataCenterZkRegistry;
    private final DelayedCloseDCZkRegistry delayedCloseDCZkRegistry;
    private final AwacsBalancerManager awacsBalancerManager;

    public DelayedCloseController(ClosedDataCenterZkRegistry closedDataCenterZkRegistry,
                                  DelayedCloseDCZkRegistry delayedCloseDCZkRegistry,
                                  AwacsBalancerManager awacsBalancerManager)
    {
        this.closedDataCenterZkRegistry = closedDataCenterZkRegistry;
        this.delayedCloseDCZkRegistry = delayedCloseDCZkRegistry;
        this.awacsBalancerManager = awacsBalancerManager;
    }

    @Override
    protected Duration defaultDelay() {
        return Duration.standardMinutes(1);
    }

    @Override
    protected void execute() {
        boolean isSomeDCsClosed = closedDataCenterZkRegistry.getAll().filter(ClosedDataCenterInfo::isClosed).isNotEmpty();
        delayedCloseDCZkRegistry.getAll()
                .filter(DelayedCloseDCZkRegistry.DelayedCloseDC::isBeforeNow)
                .forEach(delayedCloseDC -> {
                    if (isSomeDCsClosed) {
                        logger.warn("Closing of several DC together is prohibited");
                        return;
                    }
                    if (delayedCloseDC.isDb) {
                        closedDataCenterZkRegistry.closeDbsDc(delayedCloseDC.getDcName());
                    } else {
                        awacsBalancerManager.closeAllBalancers(delayedCloseDC.getDcName());
                        closedDataCenterZkRegistry.closeDc(delayedCloseDC.getDcName());
                    }
                    delayedCloseDCZkRegistry.remove(delayedCloseDC.getId());
                });
    }
}
