# -*- coding: utf-8 -*-
"""
Ищет у пользователя альбом с папкой в album_items и удаляет album_item, ссылающийся на папку.

https://st.yandex-team.ru/MOBDISK-19877

echo '<UID>' | sudo python albums_remove_folders.py
"""
import sys
import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
from mpfs.dao.session import Session


SQL_FIND = r"""
SELECT a.uid, a.id as item_id, code.fid_to_path(f.fid, f.uid)
FROM disk.album_items a
JOIN disk.folders f ON a.uid = f.uid and '\x' || a.obj_id = CAST(f.id as text)
WHERE a.uid = :uid;
"""

SQL_DELETE_ALBUM_ITEM = r"""
DELETE FROM disk.album_items WHERE uid=:uid AND id=:item_id
"""

def delete_invalid_album_items(uid):
    session = Session.create_from_uid(uid)
    count = 0
    for item in session.execute(SQL_FIND, {'uid': uid}):
        count += session.execute(SQL_DELETE_ALBUM_ITEM, {'uid': uid, 'item_id': item.item_id}).rowcount
    print "%s\t%s" % (uid, count)


if __name__ == '__main__':
    for uid in sys.stdin:
        uid = uid.strip()
        delete_invalid_album_items(uid)
