# -*- coding: utf-8 -*-
"""
Блокировка файлов по storage_id
https://st.yandex-team.ru/CHEMODAN-74079
Как запускать:
1. На вход в параметр filepath передаем csv файл с нужными storage_id
2. При указании флага --dry-run вставка строк не происходит
"""
from argparse import ArgumentParser
import csv
import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
from mpfs.core.metastorage.control import support_blocked_hids


HID_BLOCK_TYPE = 'only_view_delete'


def main(filepath, dry_run, start=1, end=None):
    if dry_run:
        print("It's dry-run!")

    count_hids = support_blocked_hids.count()
    print('count_hids before block: %s' % count_hids)

    with open(filepath) as f:
        reader = csv.DictReader(f, delimiter=';', quoting=csv.QUOTE_MINIMAL)
        for i, row in enumerate(reader, start=1):
            if i < start or end is not None and i > end:
                continue
            if i % 100 == 0:
                print('row %s, users: %s' % (i, row['users']))
            storage_id = row['storage_id'].replace('-', '')
            if not dry_run:
                support_blocked_hids.put(storage_id, HID_BLOCK_TYPE)
    count_hids = support_blocked_hids.count()
    print('count_hids after block: %s' % count_hids)


if __name__ == '__main__':
    parser = ArgumentParser()
    parser.add_argument('--filepath', dest='filepath', type=str, required=True)
    parser.add_argument('--dry-run', dest='dry_run', action='store_true')
    parser.add_argument('-s', dest='start', type=int, default=1)
    parser.add_argument('-e', dest='end', type=int, default=None)
    args = parser.parse_args()

    main(args.filepath, args.dry_run, args.start, args.end)
