# -*- coding: utf-8 -*-
from argparse import ArgumentParser
import mpfs.engine.process
from mpfs.core.filesystem.cleaner.models import DeletedStid, DeletedStidSources
from mpfs.metastorage.postgres.queries import SQL_REMOVE_HANGING_STORAGE_FILES
mpfs.engine.process.setup_admin_script()
from mpfs.dao.session import Session


SQL_GET_LINKS = r'SELECT * FROM disk.additional_file_links LIMIT 100;'
SQL_GET_FILE = r'''
SELECT
    uid, fid, is_live_photo,
    (SELECT path FROM code.fid_to_path(fid, uid)) as path,
    storage_id, stid, digest_stid, preview_stid, size
FROM disk.files
LEFT JOIN disk.storage_files USING (storage_id)
WHERE uid = :uid and fid = :fid
'''
SQL_UNSET_LIVE_PHOTO_FILE_FLAGS = r'UPDATE disk.files SET is_live_photo=NULL WHERE uid = :uid AND fid = :fid'
SQL_DELETE_FILE = r"DELETE FROM disk.files WHERE uid = :uid AND fid = :fid"
SQL_DELETE_LINK = r'DELETE FROM disk.additional_file_links WHERE uid = :uid AND main_file_fid = :main_file_fid AND type = :type'


def save_stid_to_clean_log(file_row):
    stids = (
        (file_row.stid, 'file_mid'),
        (file_row.digest_stid, 'digest_mid'),
        (file_row.preview_stid, 'pmid'),
    )
    deleted_stids_objs = []
    for (stid, stid_type) in stids:
        if stid is None:
            continue
        deleted_stids_objs.append(
            DeletedStid(
                stid=stid,
                stid_type=stid_type,
                size=file_row.size if stid_type == 'file_mid' else None,
                stid_source='additional_links_clean_up',
            )
        )
    DeletedStid.controller.bulk_create(deleted_stids_objs, get_size_from_storage=True)


def process_one_link(session, link_row):
    additional_file_id = {'uid': link_row.uid, 'fid': link_row.additional_file_fid}
    main_file_id = {'uid': link_row.uid, 'fid': link_row.main_file_fid}
    link_id = {'uid': link_row.uid, 'main_file_fid': link_row.main_file_fid, 'type': link_row.type}

    additional_file = session.execute(SQL_GET_FILE, additional_file_id).fetchone()
    if additional_file:
        assert additional_file.path.startswith('/additional/')
        save_stid_to_clean_log(additional_file)

    with session.begin():
        session.execute(SQL_UNSET_LIVE_PHOTO_FILE_FLAGS, main_file_id)
        if additional_file:
            session.execute(SQL_DELETE_FILE, additional_file_id)
            session.execute(SQL_REMOVE_HANGING_STORAGE_FILES, {'storage_ids': (additional_file.storage_id,)})
        session.execute(SQL_DELETE_LINK, link_id)
    print link_row


def main(shard_id):
    session = Session.create_from_shard_id(shard_id)
    while True:
        rows = session.execute(SQL_GET_LINKS).fetchall()
        if len(rows) == 0:
            break
        for row in rows:
            process_one_link(session, row)


if __name__ == '__main__':
    parser = ArgumentParser()
    parser.add_argument('-s', dest='shard_id', type=str, required=True)
    args = parser.parse_args()

    main(args.shard_id)
