# -*- coding: utf-8 -*-
import sys
import requests
requests.packages.urllib3.disable_warnings()

from argparse import ArgumentParser

from mpfs.engine.process import setup_admin_script
setup_admin_script()

from mpfs.core.services.uaas_service import uaas
from mpfs.common.util import from_json, to_json
from mpfs.common.util.user_agent_parser import UserAgent


TABLET_PREFIX = '-tablet'
DEVICES = {
    UserAgent.IOS: 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_1 like Mac OS X) AppleWebKit/604.3.5 (KHTML, like Gecko) Version/11.0 Mobile/15B93 Safari/604.1',
    UserAgent.ANDROID: 'Mozilla/5.0 (Linux; Android 5.1.1; Nexus 6 Build/LYZ28E) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3265.0 Mobile Safari/537.36',
    UserAgent.IOS + TABLET_PREFIX: 'Mozilla/5.0 (iPad; CPU OS 9_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13B143 Safari/601.1',
    UserAgent.ANDROID + TABLET_PREFIX: 'Mozilla/5.0 (Linux; Android 4.4; Nexus 5 Build/_BuildID_) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36',
    'desktop': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.102 YaBrowser/18.11.1.80',
}


REGION_IDS = {
    'ru': '225',
}


def _decode_experiments(encoded_experiments):
    result = []
    for experiments in encoded_experiments.split(','):
        experiments = experiments.decode('base64')
        experiments = from_json(experiments)
        for exp in experiments:
            if exp.get('HANDLER') == 'DISK':
                result.append(exp)
    return result


if __name__ == '__main__':
    parser = ArgumentParser(description="Disk exps.")
    parser.add_argument('--region', required=False, choices=REGION_IDS.keys(), help='Region ID')
    parser.add_argument('--device', required=False, choices=DEVICES.keys(), help='Device type')
    args = parser.parse_args()

    headers = {}
    if args.device:
        headers['User-Agent'] = DEVICES[args.device]
    if args.region:
        headers['X-Region-City-Id'] = REGION_IDS[args.region]

    for line in sys.stdin:
        uid = line.strip()
        if not uid:
            continue
        try:
            resp = uaas.request('GET', '/', params={'uuid': uid}, headers=headers)
            exps = []
            if resp.headers.get('X-Yandex-ExpFlags'):
                exps = _decode_experiments(resp.headers.get('X-Yandex-ExpFlags'))
            print to_json({uid: exps})
        except Exception as exc:
            print "ERROR: %s %s" % (uid, exc)
