# -*- coding: utf-8 -*-
"""
Выгрузка размера фотоанлима по пользователям

https://st.yandex-team.ru/CHEMODAN-73031

Как выгружать:
1. Получить список всех shard_id PG в файл: pg_shard_ids
2. Положить этот скрипт на copydb
3. По каждому шарду запустить скрипт:
> mkdir results
> for i in `cat pg_shard_ids`; do sudo python photounlim_space_usage.py -s $i > results/${i}.json & done
4. Выгрузку отправить на YT:
> cat results/* | YT_PROXY=hahn YT_TOKEN=XXXXXXXXXXX yt write-table --format json //home/mpfs-stat/storage/<EXPORT_DATE>_photounlim_size
"""
import json
from argparse import ArgumentParser

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
from mpfs.dao.session import Session, PGReadPreference


SQL_ATTACH_SIZE = u'''
select sum(s.size) as attach_size
from disk.files f
JOIN disk.storage_files s on f.storage_id = s.storage_id
where
  f.uid = :uid and
  f.source = 'attach' and
  f.custom_setprop_fields->'short_url_named' IS NOT NULL;
'''
SQL_GET_UIDS = r"SELECT uid, version FROM disk.user_index where user_type != 'attach' AND uid > :uid ORDER BY uid LIMIT 100;"


def iterate_over_user_index(session):
    last_uid = -1
    count = 0
    while True:
        result = session.execute(SQL_GET_UIDS, {'uid': last_uid}).fetchall()
        for row in result:
            yield row
            last_uid = row.uid
        if len(result) == 0:
            break


def long_or_zero(value):
    if value:
        return long(value)
    return 0


def main(shard_id):
    session = Session.create_from_shard_id(shard_id, read_preference=PGReadPreference.secondary_preferred)
    user_index_iterator = iterate_over_user_index(session)
    for user_index_row in user_index_iterator:
        try:
            counters = list(session.execute(SQL_ATTACH_SIZE, {'uid': user_index_row.uid}).fetchall())
            print '\t'.join([str(user_index_row.uid), str(long_or_zero(counters[0].attach_size))])
        except Exception as exc:
            print "ERROR: %s %s" % (user_index_row.uid, exc.message)
            session = Session.create_from_shard_id(shard_id, read_preference=PGReadPreference.secondary_preferred)


if __name__ == '__main__':
    parser = ArgumentParser()
    parser.add_argument('-s', dest='shard_id', type=str, required=True)
    args = parser.parse_args()
    main(args.shard_id)
