# -*- coding: utf-8 -*-
"""
Выгрузка размера фотоанлима по пользователям

https://st.yandex-team.ru/CHEMODAN-73031

Как выгружать:
1. Получить список всех shard_id PG в файл: pg_shard_ids
2. Положить этот скрипт на copydb
3. По каждому шарду запустить скрипт:
> mkdir results
> for i in `cat pg_shard_ids`; do sudo python photounlim_space_usage.py -s $i > results/${i}.json & done
4. Выгрузку отправить на YT:
> cat results/* | YT_PROXY=hahn YT_TOKEN=XXXXXXXXXXX yt write-table --format json //home/mpfs-stat/storage/<EXPORT_DATE>_photounlim_size
"""
import json
from argparse import ArgumentParser

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
from mpfs.dao.session import Session, PGReadPreference


SQL_DOWNLOADS_SIZE = u'''
SELECT
    COUNT(1) AS downloads_cnt,
    SUM(s.size) as downloads_size
FROM disk.files f JOIN disk.storage_files s USING (storage_id)
WHERE
    uid = :uid AND (select path from code.fid_to_path(f.fid, f.uid)) LIKE '/disk/Downloads/%'
UNION ALL
SELECT
    COUNT(1) AS downloads_cnt,
    SUM(s.size) as downloads_size
FROM disk.files f JOIN disk.storage_files s USING (storage_id)
WHERE
    uid = :uid AND (select path from code.fid_to_path(f.fid, f.uid)) LIKE '/disk/Загрузки/%';
'''
SQL_GET_UIDS = r'SELECT uid, version FROM disk.user_index where uid > :uid ORDER BY uid LIMIT 100;'


def iterate_over_user_index(session):
    last_uid = -1
    count = 0
    while True:
        result = session.execute(SQL_GET_UIDS, {'uid': last_uid}).fetchall()
        for row in result:
            yield row
            last_uid = row.uid
        if len(result) == 0:
            break


def long_or_zero(value):
    if value:
        return long(value)
    return 0


def main(shard_id):
    session = Session.create_from_shard_id(shard_id, read_preference=PGReadPreference.secondary_preferred)
    user_index_iterator = iterate_over_user_index(session)
    for user_index_row in user_index_iterator:
        try:
            downloads_counters = list(session.execute(SQL_DOWNLOADS_SIZE, {'uid': user_index_row.uid}).fetchall())
            print json.dumps({
                'shard_id': shard_id,
                'uid': user_index_row.uid,
                'disk_version': user_index_row.version,
                'downloads_files_num': downloads_counters[0].downloads_cnt,
                'downloads_files_size': long_or_zero(downloads_counters[0].downloads_size),
                'downloads_ru_files_num': downloads_counters[1].downloads_cnt,
                'downloads_ru_files_size': long_or_zero(downloads_counters[1].downloads_size)
            })
        except Exception as exc:
            print "ERROR: %s %s" % (user_index_row.uid, exc.message)
            session = Session.create_from_shard_id(shard_id, read_preference=PGReadPreference.secondary_preferred)


if __name__ == '__main__':
    parser = ArgumentParser()
    parser.add_argument('-s', dest='shard_id', type=str, required=True)
    args = parser.parse_args()
    main(args.shard_id)
