# -*- coding: utf-8 -*-
"""
Выгрузить stid'ы юзеров из базы MPFS на YT

https://st.yandex-team.ru/CHEMODAN-83085
"""
import requests
requests.packages.urllib3.disable_warnings()

import sys

from mpfs.engine.process import setup_admin_script
setup_admin_script()

from mpfs.dao.base import Session
from mpfs.metastorage.postgres.query_executer import ReadPreference


SQL = r'''
SELECT (
    SELECT
        COUNT(1)
    FROM disk.files
    WHERE uid = :uid
) as files_amount,
(
    SELECT
        COUNT(1)
    FROM disk.folders
    WHERE uid = :uid
) AS folders_amount
'''


conn = None


def get_connection(uid):
    global conn
    if conn is None:
        conn = Session.create_from_uid(uid, read_preference=ReadPreference.secondary)
    return conn


def process(uids):
    for uid in uids:
        try:
            connection = get_connection(uid)
            cursor = connection.execute(SQL, {'uid': uid})
            for counters in cursor:
                print '\t'.join([str(uid), str(counters[0]), str(counters[1])])
        except Exception as exc:
            global conn
            conn = None
            print 'ERROR: %s %s' % (uid, exc.message)


if __name__ == '__main__':
    uids = [long(line.strip())
            for line in sys.stdin.readlines()
            if line.strip() and line.strip().isdigit()]

    process(uids)
