# -*- coding: utf-8 -*-
"""
Выгрузить stid'ы юзеров из базы MPFS на YT

https://st.yandex-team.ru/CHEMODAN-83085
"""
import requests
requests.packages.urllib3.disable_warnings()

import sys

from mpfs.engine.process import setup_admin_script
setup_admin_script()

from mpfs.dao.base import Session
from mpfs.metastorage.postgres.query_executer import ReadPreference
from mpfs.metastorage.postgres.services import Sharpei


UIDS_FILE_PATH = 'uids'
RESULT_FOLDER = '//home/mpfs-stat/tmps/CHEMODAN-83085'
RESULT_TABLE_TMPL = RESULT_FOLDER + '/%s'

QUERY_RESULT_LIMIT = 100000

SQL = r'''
SELECT s.stid AS stid FROM disk.files f JOIN disk.storage_files s USING (storage_id) WHERE uid = :uid
LIMIT :limit OFFSET :offset
;
'''


sharpei = Sharpei()
conn = None


# Мишки и крошки
SKIP_STIDS = [
    '16616.yadisk:122625849.63815294453184935839489081024',
    '16185.yadisk:122625849.97099719023770539551723407024',
    '16941.yadisk:122625849.20513669411726691649948687610',
    '16731.yadisk:122625849.1931589222118251447816377424007',
    '320.yadisk:285498249.E58000:1916856380118943824534921650699',
    '11459.yadisk:52135854.35740169572147360030325978867',
    '320.yadisk:359371010.E134657:240749216920903380333786562937',
    '11203.yadisk:122625849.142379413010140424555323781581',
    '10935.yadisk:122625849.41025208266268691804527659031',
    '10956.yadisk:122625849.58434849348741534923657697881',
    '10893.yadisk:122625849.157898872433843908629514450437',
    '3235.yadisk:44288518.338928772478015747943736860745',
    '10797.yadisk:122625849.3754616202535163251619995880',
    '8615.yadisk:122625849.576205310113348798424317428185',
    '8284.yadisk:122625849.3206491990176987580919283329926',
    '8282.yadisk:122625849.2754523535211736573514285159482',
    '8125.yadisk:122625849.375461620117275771988764872',
    '4583.yadisk:32119825.17351765516058407351980685451',
    '11354.yadisk:222283434.3471771892141532379764135828471',
    '8701.yadisk:122625849.970997190179242014561883619704',
    '20629.yadisk:187343030.227576049294867787542229655470',
    '3851.yadisk:129526856.2802327583133897571010898382480',
    '2786.yadisk:89031628.320649199031655824029717325237'
]


def get_connection(uid):
    global conn
    if conn is None:
        conn = Session.create_from_uid(uid, read_preference=ReadPreference.secondary)
    return conn


def fetch_all_stids(uid):
    offset = 0
    connection = get_connection(uid)
    cursor = connection.execute(SQL, {'uid': uid, 'limit': QUERY_RESULT_LIMIT, 'offset': offset})
    result = {item[0]
              for item in cursor
              if ':share_production.' not in item[0] and item[0] not in SKIP_STIDS}
    while result:
        for stid in result:
            print stid

        offset += QUERY_RESULT_LIMIT
        cursor = connection.execute(SQL, {'uid': uid, 'limit': QUERY_RESULT_LIMIT, 'offset': offset})
        result = {item[0]
                  for item in cursor
                  if ':share_production.' not in item[0] and item[0] not in SKIP_STIDS}


def process(uids):
    for uid in uids:
        try:
            fetch_all_stids(uid)
        except Exception as exc:
            global conn
            conn = None
            print 'ERROR: %s %s' % (uid, exc.message)


if __name__ == '__main__':
    uids = [long(line.strip())
            for line in sys.stdin.readlines()
            if line.strip() and line.strip().isdigit()]

    process(uids)
