#!/usr/bin/env python2
# -*- coding: utf-8 -*-

from __future__ import print_function

from argparse import ArgumentParser
import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
from mpfs.dao.session import Session


def get_face_album_count(uid):
    session = Session.create_from_uid(str(uid))
    print (
        uid,
        session
            .execute(
                "select face_clusters_version from disk.albums_info"
                " where uid = :uid and face_clusters_version is not null;",
                uid = uid,
            )
            .fetchone(),
        session
            .execute(
                "select count(*) from disk.albums"
                " where uid = :uid and album_type = 'faces';",
                uid = uid,
            )
            .fetchone()
    )


UIDS = [185086155, 676037085, 81607693, 10614606, 791439580, 6129688, 1104525603, 14521936, 1020666124, 82003486, 14791889, 666787365, 956968862, 439146777, 602933981, 326179500, 256980167, 26111887]

if __name__ == '__main__':
    for uid in UIDS:
        get_face_album_count(uid)
