#!/usr/bin/env python3

from pprint import pprint
import requests

UIDS = [
    # команда
    24855543, 199919915, 1090778349, 230200968, 194836852,

    # для Романа Григорьева
    # 69194959,
    194836852,
    # 508675522,
    # 443251863,
    # 926459303,
]

def face_get_clusters(uid):
    return (
        requests.get(
            'https://disk-mass-processing.search.yandex.net/api/faces/clusters',
            params={'uid': uid}
        )
        .json()
    )

def check_indexed():
    indexed = []
    notindexed = []
    for uid in UIDS:
        print('checking uid =', uid)
        clusters = face_get_clusters(uid)
        is_indexed = clusters['version'] != 0
        if is_indexed:
            indexed.append(uid)
        else:
            notindexed.append(uid)
            print(clusters)
    print({'indexed': indexed, 'notindexed': notindexed})

if __name__ == '__main__':
    check_indexed()
