#!/usr/bin/env python2
# -*- coding: utf-8 -*-

from __future__ import print_function

from argparse import ArgumentParser
from collections import defaultdict
from copy import copy
import yaml
import datetime

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
from mpfs.dao.session import Session


def connect_to_all_shards():
    with open('uids_done.txt', 'w'):
        pass
    with open('uids_running_2020-09-27.txt', 'w'):
        pass
    sessions = Session.create_for_all_shards()
    # pool = Pool(10)
    # print(pool.map(get_running, sessions))
    result = defaultdict(int)
    running = defaultdict(int)
    running_uids = defaultdict(list)
    for session in sessions:
        rows = (
            session
            .execute("""
                select
                    faces_indexing_state as state,
                    faces_indexing_state_time::date as date,
                    count(1),
                    array_agg(uid) as uids
                from disk.user_index
                where faces_indexing_state is not null
                group by state, date;
            """)
            .fetchall()
        )
        for state, date, count, uids in rows:
            if state == 'running':
                running[copy(date)] += count
                running_uids[copy(date)] += uids
            else:
                result[state] += count
            if state != 'not_indexed':
                with open('uids_done.txt', 'a') as uids_file:
                    uids_file.writelines(str(uid) + '\n' for uid in uids)
            if state == 'running' and date == datetime.date(2020, 9, 27):
                with open('uids_running_2020-09-27.txt', 'a') as uids_file:
                    uids_file.writelines(str(uid) + '\n' for uid in uids)
        print(
            yaml.safe_dump(
                dict(
                    result,
                    running=dict(running),
                    running_uids={
                        k: v for k, v in running_uids.items() if len(v) < 10
                    },
                ),
                explicit_start=True,
            ),
            end='',
        )


if __name__ == '__main__':
    # # tmpl for argparser
    # parser = ArgumentParser()
    # parser.add_argument('-u', dest='uid', type=str, required=True)
    # parser.add_argument('positional')
    # args = parser.parse_args()

    # print args.uid, args.positional
    connect_to_all_shards()
