#!/usr/bin/env python2
# -*- coding: utf-8 -*-

from __future__ import print_function

import json

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()

from mpfs.core.services.djfs_albums import djfs_albums
from mpfs.dao.session import Session


album_names = {
    item['cluster_id']: item['name'] for item in json.load(open('tigran.json'))
}
# print(album_names)

uid = '10761'
session = Session.create_from_uid(uid)
for cluster_id, name in album_names.iteritems():
    album_id, = (
        session
        .execute(
            """ SELECT album_id FROM disk.album_face_clusters
                WHERE uid = :uid AND cluster_id = :cluster_id""",
            uid=uid,
            cluster_id=cluster_id,
        )
        .fetchone()
    )
    album_title, = (
        session
        .execute(
            'SELECT title FROM disk.albums WHERE uid = :uid AND id = :id',
            uid=uid, id=album_id,
        )
        .fetchone()
    )
    if album_title == '':
        print(
            djfs_albums.request(
                'PATCH',
                '/api/v1/albums/album_set_attr',
                {
                    'title': name,
                    'uid': uid,
                    'album_id': bytes(album_id).encode('hex')
                },
            )
        )
    elif album_title == name:
        print('OK', cluster_id, name, repr(bytes(album_id)), album_title)
    else:
        print('MISMATCH', cluster_id, name, repr(bytes(album_id)), album_title)
