# -*- coding: utf-8 -*-
"""
Считать кол-во пользователей в разбвике по geo-альбомам (geo_id)

https://st.yandex-team.ru/CHEMODAN-72447
"""
import collections

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
from mpfs.dao.session import Session


SQL = """
SELECT geo_id, MIN(title) as title, COUNT(1) as cnt
FROM disk.albums
WHERE geo_id > -1 AND hidden = false
GROUP BY geo_id;
"""


def main():
    geo_id_counter = collections.Counter()
    geo_id_title_map = {}
    sessions = Session.create_for_all_shards()
    for session in sessions:
        for row in session.execute(SQL):
            geo_id_counter[row.geo_id] += row.cnt
            geo_id_title_map[row.geo_id] = row.title

    for geo_id, cnt in geo_id_counter.most_common():
        print "%s,%i,%s" % (geo_id, cnt, geo_id_title_map[geo_id].encode('utf-8'))


if __name__ == '__main__':
    main()
