# -*- coding: utf-8 -*-
"""
Получить снепшот фотосреза из smartcache
"""
from argparse import ArgumentParser
import requests


def main(uid):
   resp = requests.get("http://smartcache-worker.disk.yandex.net:80/smartcache/photoslice-init-snapshot?__uid=%s" % uid)
   try:
      slice_info = resp.json()
      slice_id = slice_info['result']['photoslice_id']
      slice_ver = slice_info['result']['revision']
   except:
      print resp.status_code
      print resp.content
      raise
   resp = requests.get("http://smartcache.disk.yandex.net/smartcache/smartcache-snapshot?__uid=%s&photoslice-id=%s&rev=%s" % (uid, slice_id, slice_ver))
   print resp.content


if __name__ == '__main__':
    parser = ArgumentParser()
    parser.add_argument('uid')
    args = parser.parse_args()

    main(args.uid)
