# -*- coding: utf-8 -*-
"""
Выгрузка размера фотоанлима по пользователям

https://st.yandex-team.ru/CHEMODAN-73031

Как выгружать:
1. Получить список всех shard_id PG в файл: pg_shard_ids
2. Положить этот скрипт на copydb
3. По каждому шарду запустить скрипт:
> mkdir results
> for i in `cat pg_shard_ids`; do sudo python photounlim_space_usage.py -s $i > results/${i}.json & done
4. Выгрузку отправить на YT:
> cat results/* | YT_PROXY=hahn YT_TOKEN=XXXXXXXXXXX yt write-table --format json //home/mpfs-stat/storage/<EXPORT_DATE>_photounlim_size
"""
import json
from argparse import ArgumentParser

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
from mpfs.dao.session import Session, PGReadPreference


SQL_PHOTOUNLIM_SIZE = r'''
SELECT
    COUNT(1) as cnt,
    SUM(size) as sum_size
FROM disk.files
LEFT JOIN disk.storage_files USING (storage_id)
WHERE uid = :uid and parent_fid = (select fid from code.path_to_fid('/photounlim', :uid))
'''
SQL_GET_UIDS = r'SELECT uid, version FROM disk.user_index where uid > :uid ORDER BY uid LIMIT 100;'


def iterate_over_user_index(session):
    last_uid = -1
    count = 0
    while True:
        result = session.execute(SQL_GET_UIDS, {'uid': last_uid}).fetchall()
        for row in result:
            yield row
            last_uid = row.uid
        if len(result) == 0:
            break


def main(shard_id):
    session = Session.create_from_shard_id(shard_id, read_preference=PGReadPreference.secondary_preferred)
    user_index_iterator = iterate_over_user_index(session)
    for user_index_row in user_index_iterator:
        unlim_counters = session.execute(SQL_PHOTOUNLIM_SIZE, {'uid': user_index_row.uid}).fetchone()
        print json.dumps({
            'shard_id': shard_id,
            'uid': user_index_row.uid,
            'disk_version': user_index_row.version,
            'files_num': unlim_counters.cnt,
            'files_size': int(unlim_counters.sum_size) if unlim_counters.sum_size else 0,
        })


if __name__ == '__main__':
    parser = ArgumentParser()
    parser.add_argument('-s', dest='shard_id', type=str, required=True)
    args = parser.parse_args()
    main(args.shard_id)
