# -*- coding: utf-8 -*-
from argparse import ArgumentParser
import mpfs.engine.process

mpfs.engine.process.setup_admin_script()
from mpfs.common.static.tags.billing import *
from mpfs.common.util import ctimestamp, time_to_str
from mpfs.config import settings
from mpfs.core.billing import Client
from mpfs.core.billing.service import DEFAULT_SERVICE_PID
from mpfs.core.billing.service import ServiceList
from mpfs.core.queue import mpfs_queue as queue

log = mpfs.engine.process.get_default_log()


def push_billing_tasks(uid, dry_run=False):
    def select_and_push_services(border=None, state=None, command=None, uid=uid, dry_run=False):
        params = {BTIME_LT: border, STATE: state, CLIENT: Client(uid)}
        services = ServiceList(**params)
        log.info('total %s services (state = %s, btime < %s (%s), uid = %s) need to be processed' %
                 (len(services), state, border, time_to_str(border), uid)
                 )
        for item in services:
            if item.get(PID) == DEFAULT_SERVICE_PID:
                continue
            uid, sid = item[UID], item[SID]
            if not dry_run:
                if command == BILLING_SERVICE_SUBSCRIPTION_CANCELLED:
                    queue.put({SID: sid, UID: uid}, command, deduplication_id='%s_%s_%s' % (command, uid, sid))
                elif command == BILLING_INAPP_SERVICE_SYNCRONIZE:
                    queue.put({SID: sid, UID: uid}, command, deduplication_id=uid)
                else:
                    queue.put({SID: sid, UID: uid}, command)
            log.info('service %s:%s pushed to %s (dry_run=%s)' % (uid, sid, command, dry_run))

    now = ctimestamp()
    log.info('pushing billing commands, base date is %s (%s)' % (now, time_to_str(now)))
    """
    Услуги без установленного состояния
    Выбирем и ставим на стандартный биллинг
    """
    standart_billing = now - settings.billing['billing_delay']
    select_and_push_services(
        uid=uid,
        dry_run=dry_run,
        border=standart_billing,
        state=[None, SUBSCRIPTION_CANCELLED],
        command=BILLING_SERVICE_STANDART_BILLING
    )
    """
    Неоплаченные в течении длительного времени услуги с подпиской
    Если услуга зависла в оплате более n дней (см. конфиг) ее надо отключить
    """
    regular_payment_cancel = now - settings.billing['subscription_payment_cancel']
    select_and_push_services(
        uid=uid,
        dry_run=dry_run,
        border=regular_payment_cancel,
        state=[WAITING_PAYMENT, PAYMENT_DELAYED, PAYMENT_CANCELLED],
        command=BILLING_SERVICE_SUBSCRIPTION_CANCELLED
    )
    """
    Услуги с подпиской, заждавшиеся коллбека от биллинга
    По умолчанию ждем один час от момента предыдущей оплаты
    """
    regular_payment_delay = now - settings.billing['subscription_payment_delay']
    select_and_push_services(
        uid=uid,
        dry_run=dry_run,
        border=regular_payment_delay,
        state=WAITING_PAYMENT,
        command=BILLING_SERVICE_SUBSCRIPTION_DELAYED
    )
    """
    MVP1
    In-app услуги при наступлении expire_time отправляем в грейс период. Меняется статус на INAPP_GRACE_PERIOD
    """
    select_and_push_services(
        uid=uid,
        dry_run=dry_run,
        border=now,
        state=INAPP_ACTIVE,
        command=BILLING_INAPP_SERVICE_SYNCRONIZE
    )
    """
    MVP1
    In-app услуги, которые долго находились в грейс периоде, удаляются
    """
    select_and_push_services(
        uid=uid,
        dry_run=dry_run,
        border=now - settings.billing['inapp_grace_period'],
        state=INAPP_GRACE_PERIOD,
        command=BILLING_INAPP_SERVICE_SYNCRONIZE
    )

if __name__ == '__main__':
    parser = ArgumentParser()
    parser.add_argument('-u', dest='uid', type=str, required=True)
    parser.add_argument('-n', '--dry-run', action='store_true')
    args = parser.parse_args()
    push_billing_tasks(args.uid, dry_run=args.dry_run)

