# -*- coding: utf-8 -*-
"""
Для зависших операций, поставить таск обработки операции в очередь.

Скрипт никак не проверяет, есть ли таск уже в очереди или нет - может поставиться дубликат
"""
from argparse import ArgumentParser

import datetime
from mpfs.engine.process import setup_admin_script
setup_admin_script()

from mpfs.core.operations.logic.frozen import fetch_frozen_important_operations
from mpfs.core.queue import mpfs_queue


def main(put_task=False):
    for i in fetch_frozen_important_operations():
        if i.type == 'user' and i.subtype == 'permanent_delete':
            continue
        dt = datetime.datetime.utcfromtimestamp(int(i.ctime))
        print "%s\t%s\t%s\t%s\t%s" % (i.uid, i.id, i.type, i.subtype, dt)
        if put_task:
            mpfs_queue.put({'oid': i.id, 'uid': i.uid}, 'operation')


if __name__ == '__main__':
    parser = ArgumentParser()
    parser.add_argument('-p', dest='put', action='store_true')
    args = parser.parse_args()

    main(put_task=args.put)
