# -*- coding: utf-8 -*-
"""
Проверить об сторадж есть ли stid
На stdin подать stid-ы

https://st.yandex-team.ru/CHEMODAN-70951
"""
import sys
from multiprocessing.pool import ThreadPool

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
from mpfs.core.services.mulca_service import Mulca

MULCA_SERVICE = Mulca()


def check_stid(stid):
    try:
        result = MULCA_SERVICE.is_file_exist(stid)
    except Exception:
        result = 'Error'
    return stid, result


if __name__ == '__main__':
    stid_stream = (line.strip() for line in sys.stdin)
    pool = ThreadPool(processes=20)
    result = pool.imap_unordered(check_stid, stid_stream)
    for stid, is_exists in result:
        print "%s\t%s" % (stid, is_exists)
    pool.close()
    pool.join()
