# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from settings import *  # noqa
from django_idm_api.settings import *

import yaml

DEBUG = False

ALLOWED_HOSTS = ['.yandex-team.ru']

# секретные ключи в конфиге должны иметь секции следующего вида
# api_admin:
#   database:
#     default:
#       name: ...
#       user: ...
#       password: ...
#       host: ...
#       port: ...
#     ro_sync:
#       name: ...
#       user: ...
#       password: ...
#       host: ...
#       port: ...
#     ro_local:
#       name: ...
#       user: ...
#       password: ...
#       host: ...
#       port: ...
#   secret_key: ...
# "ro" означает read only :)
with open('/etc/yandex/disk-secret-keys.yaml') as f:
    content = f.read()

data = yaml.load(content)
api_admin_section = data['api_admin']
database_section = api_admin_section['database']

default_database_key = 'default'
ro_sync_database_key = 'ro_sync'
ro_local_database_key = 'ro_local'
DATABASES['default'] = {
    # основная база
    'ENGINE': 'django.db.backends.postgresql',
    'NAME': database_section[default_database_key]['name'],
    'USER': database_section[default_database_key]['user'],
    'PASSWORD': database_section[default_database_key]['password'],
    'HOST': database_section[default_database_key]['host'],
    'PORT': database_section[default_database_key]['port'],
}
DATABASES['ro_sync'] = {
    # синхронная реплика
    'ENGINE': 'django.db.backends.postgresql',
    'NAME': database_section[ro_sync_database_key]['name'],
    'USER': database_section[ro_sync_database_key]['user'],
    'PASSWORD': database_section[ro_sync_database_key]['password'],
    'HOST': database_section[ro_sync_database_key]['host'],
    'PORT': database_section[ro_sync_database_key]['port'],
}
DATABASES['ro_local'] = {
    # ближайшая база
    'ENGINE': 'django.db.backends.postgresql',
    'NAME': database_section[ro_local_database_key]['name'],
    'USER': database_section[ro_local_database_key]['user'],
    'PASSWORD': database_section[ro_local_database_key]['password'],
    'HOST': database_section[ro_local_database_key]['host'],
    'PORT': database_section[ro_local_database_key]['port'],
}


IDM_URL_PREFIX = 'cloud-api/idm/'

tvm_section = api_admin_section['tvm']

IDM_API_TVM_SETTINGS = {
    'client_id': tvm_section['client_id'],
    'secret': tvm_section['secret_key'],
}

MIDDLEWARE_CLASSES.append('django_idm_api.middleware.TVMMiddleware')


SECRET_KEY = api_admin_section['secret_key']


def get_zookeeper_hosts():
    # https://c.yandex-team.ru/groups/disk_zk
    from mpfs.core.services.conductor_service import ConductorService
    return [
        '%s:2181' % h for
        h in ConductorService().get_hosts_by_group('disk_zk')
    ]

ZOOKEEPER_HOSTS = SimpleLazyObject(get_zookeeper_hosts)

ZOOKEEPER_ROOT = '/cloud-api'

ZOOKEEPER_ENVIRONMENT = 'production'
ZOOKEEPER_PASSWORD = api_admin_section['zookeeper']['password']

PROJECT_ROOT = '/usr/lib/python2.7/dist-packages/api_admin'

STATIC_ROOT = os.path.join(PROJECT_ROOT, 'collected_static')

FORCE_SCRIPT_NAME = '/cloud-api/'

STATIC_URL = os.path.join(FORCE_SCRIPT_NAME, 'static') + '/'

USE_X_FORWARDED_HOST = True
