# -*- coding: utf-8 -*-

from __future__ import unicode_literals

"""
Django settings for api_admin project.

Generated by 'django-admin startproject' using Django 1.9.

For more information on this file, see
https://docs.djangoproject.com/en/1.9/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.9/ref/settings/
"""

# caa означает Cloud Api Admin

import os
import socket
import logging.handlers

from django.utils.functional import SimpleLazyObject
from django_yauth.settings import *  # noqa

import mpfs.common.util.logger

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
dn = os.path.dirname
BASE_DIR = dn(dn(os.path.abspath(__file__)))
PROJECT_ROOT = dn(dn(dn(BASE_DIR)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.9/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'yqehayeuq+5(yf5y4ipm8l2!u_^xk0omkl8)+_*g4)ds_itcal'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = False

# LOGGING_CONFIG = 'api_admin.log.configure_logging'

ALLOWED_HOSTS = ['.yandex-team.ru']


# Application definition

INSTALLED_APPS = [
    'api_admin.apps.AuthConfigOverride',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.sites',
    'django_yauth',
    'django.contrib.admin',
    'django_idm_api',
    'crispy_forms',
    'api_admin.common',
    'api_admin.api_auth',
    'api_admin.site_auth',
]

MIDDLEWARE_CLASSES = [
    'api_admin.middleware.LogAccessMiddleware',
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    # должно быть *вместо* стандартного
    'django_yauth.middleware.YandexAuthMiddleware',
]

ROOT_URLCONF = 'api_admin.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [
            os.path.join(PROJECT_ROOT, 'lib', 'api_admin', 'templates'),
        ],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
                'api_admin.context_processors.menu'
            ],
            'libraries': {
                'utils': 'api_admin.templatetags.utils'
            }
        },
    },
]

WSGI_APPLICATION = 'wsgi.application'


# Database
# https://docs.djangoproject.com/en/1.9/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': '/etc/yandex/mpfs-api-admin/conf/db.sqlite3',
    }
}


IDM_URL_PREFIX = 'idm'


# Password validation
# https://docs.djangoproject.com/en/1.9/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = []


# Internationalization
# https://docs.djangoproject.com/en/1.9/topics/i18n/

LANGUAGE_CODE = 'ru-ru'

TIME_ZONE = 'Europe/Moscow'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.9/howto/static-files/

STATIC_URL = '/static/'

STATICFILES_DIRS = []

STATIC_ROOT = os.path.join(PROJECT_ROOT, 'lib', 'api_admin', 'collected_static')

SITE_ID = 1

AUTH_USER_MODEL = 'site_auth.User'

YAUTH_TYPE = 'intranet'

YAUTH_USE_SITES = False

YAUTH_CREATE_USER_ON_ACCESS = True

YAUTH_USE_NATIVE_USER = True

CRISPY_TEMPLATE_PACK = 'bootstrap3'

ADMIN_SITE_HEADER = 'Cloud API Admin'

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'standard': {
            'format': '%(asctime)s [%(levelname)s] %(name)s: %(message)s'
        },
        'tskv-access': {
            '()': mpfs.common.util.logger.TSKVSafeFormatter,
            'format': (
                'tskv\ttskv_format=ydisk-mpfs-api-admin-access-log\t'
                'host=%(caa_host_name)s\tname=%(name)s\t'
                'app_name=%(caa_app_name)s\tunixtime=%(created)d\t'
                'timestamp=%(asctime)s\ttimezone=+0300\t'
                'ycrid=%(caa_yandex_cloud_request_id)s\t'
                'pid=%(process)s\tmodule=%(module)s\t'
                'headers=%(headers)s\tmethod=%(method)s\t'
                'uid=%(uid)s\tclient_id=%(client_id)s\t'
                'uri=%(uri)s\tscheme=%(scheme)s'
                '\tstatus=%(status)s\trequest_time=%(request_time).3f'
            )
        },
        'tskv-default': {
            '()': mpfs.common.util.logger.TSKVSafeFormatter,
            'format': (
                'tskv\ttskv_format=ydisk-mpfs-api-admin-default-log\t'
                'host=%(caa_host_name)s\tname=%(name)s\t'
                'app_name=%(caa_app_name)s\tunixtime=%(created)d\t'
                'timestamp=%(asctime)s\ttimezone=+0300\t'
                'pid=%(process)s\tmodule=%(module)s\t'
                'message=%(message)s'
            )
        },
        'tskv-error': {
            '()': mpfs.common.util.logger.TSKVSafeFormatter,
            'format': (
                'tskv\ttskv_format=ydisk-mpfs-api-admin-default-log\t'
                'host=%(caa_host_name)s\tname=%(name)s\t'
                'app_name=%(caa_app_name)s\tunixtime=%(created)d\t'
                'timestamp=%(asctime)s\ttimezone=+0300\t'
                'pid=%(process)s\tmodule=%(module)s\t'
                'message=%(message)s'
            )
        }
    },
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
            'level': logging.getLevelName(logging.DEBUG)
        },
        'tskv-access': {
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': '/var/log/mpfs-api-admin/access-tskv.log',
            'maxBytes': 1024 * 1024 * 20,  # 20 MB
            'backupCount': 5,
            'formatter': 'tskv-access',
        },
        'tskv-default': {
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': '/var/log/mpfs-api-admin/default-tskv.log',
            'maxBytes': 1024 * 1024 * 20,  # 20 MB
            'backupCount': 5,
            'formatter': 'tskv-default',
        },
        'tskv-error': {
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': '/var/log/mpfs-api-admin/error-tskv.log',
            'maxBytes': 1024 * 1024 * 20,  # 20 MB
            'backupCount': 5,
            'formatter': 'tskv-error',
        }
    },
    'loggers': {
        '': {
            'handlers': ['console'],
            'level': logging.getLevelName(logging.INFO),
        },
        'django': {
            'handlers': ['console'],
            'level': logging.getLevelName(logging.INFO),
        },
        'mpfs-api-admin.access': {
            'handlers': ['tskv-access'],
            'level': logging.getLevelName(logging.INFO),
            'propagate': False
        },
        'mpfs-api-admin.default': {
            'handlers': ['tskv-default'],
            'level': logging.getLevelName(logging.INFO),
            'propagate': False
        },
        'mpfs-api-admin.error': {
            'handlers': ['tskv-error'],
            'level': logging.getLevelName(logging.INFO),
            'propagate': False
        },
    },
}


def get_zookeeper_hosts():
    # https://c.yandex-team.ru/groups/disk_test_zk
    from mpfs.core.services.conductor_service import ConductorService
    return [
        '%s:2181' % h for
        h in ConductorService().get_hosts_by_group('disk_test_zk')
    ]

ZOOKEEPER_HOSTS = SimpleLazyObject(get_zookeeper_hosts)

ZOOKEEPER_ROOT = '/cloud-api'

# для локальной разработки используется имя хоста
ZOOKEEPER_ENVIRONMENT = socket.gethostname()

# путь относительно рута,
# куда будут сохранены настройки аутентификации платформенных клиентов
ZOOKEEPER_PLATFORM_AUTH_SETTINGS_PATH = 'auth'

ZOOKEEPER_WORKER_STATE_APPLIED_CONFIG_BASE_PATH = '/workers/states/config/'
ZOOKEEPER_WORKER_STATE_LATEST_CONFIG_BASE_PATH = '/workers/states/latest/'

ZOOKEEPER_USER = 'disk'
ZOOKEEPER_PASSWORD = ''
