#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

MPFS
UWSGI API APP

"""
import os

from flask import Flask
from flask import request
from flask import make_response

from mpfs.config import settings
from mpfs.common.util import logger, from_json

dict_config = logger.merge_dict_configs(
    settings.logger['dict_config'], settings.platform['logger']['dict_config'])

logger.configure_logging(dict_config, os.environ['MPFS_PACKAGE'])

import mpfs.engine.process

mpfs.engine.process.setup_host_details()
mpfs.engine.process.setup_logs()

# не убирать с этого места
if not settings.platform['dynamic_settings']['isolate_zk'] and settings.platform['dynamic_settings']['apply_new_settings']:
    from mpfs.core.zookeeper.manager import ZookeeperClientManager

    try:
        zk_client = ZookeeperClientManager.create_client(base_path=settings.platform['zookeeper']['base_path'])
        zk_client.start()
        value, stats = zk_client.get(settings.platform['dynamic_settings']['auth_path'])
        zk_client.stop()
        print 'Settings updated from Zookeeper on startup.'
    except:
        from mpfs.platform.dynamic_settings.cache_reader import get_cached_auth_settings
        value = get_cached_auth_settings()
        print 'Settings updated from cache on startup.'
    settings.platform['auth'] = from_json(value)


from mpfs.core.services.conductor_service import setup_conductor_cache_update
from mpfs.core.services.hbf_service import setup_hbf_cache_update
from mpfs.core.services.tvm_service import (
    tvm,
    setup_tvm_pub_keys_update,
)
from mpfs.core.services.tvm_2_0_service import tvm2
from mpfs.platform.v2.resources import V2Namespace

from mpfs.platform import set_api_mode
from mpfs.platform.auth import ClientNetworks, TVMAuth
from mpfs.platform.routers import RegexRouter
from mpfs.platform.resources import NamespaceResource, res
from mpfs.platform.v1.resources import V1Namespace
from mpfs.platform.system.system.handlers import GetPing
from mpfs.platform.handlers import GetApiInfoHandler, HeadApiInfoHandler

from mpfs.common.static import tags
from mpfs.platform.dispatchers import InternalDispatcher, ExternalDispatcher

PLATFORM_ENABLE_PROFILING = settings.platform['enable_profiling']
LOGGER_MONITOR_ENABLED = settings.logger['monitor']['enabled']
from mpfs.engine.process import setup, pre_fork, set_register_after_fork_impl

# Чтобы мастер процесс не держал лог файлы открытыми.
logger.close_log_handlers()
# Чтобы запустить тред монитор логов после форка
set_register_after_fork_impl(mpfs.engine.process.uwsgi_after_fork)
if LOGGER_MONITOR_ENABLED:
    logger.enable_monitor()


if __name__ == '__main__':
    from optparse import OptionParser
    parser = OptionParser()
    parser.add_option('-H', '--host', type='string', dest='host', default='0.0.0.0', metavar='HOST', help='host')
    parser.add_option('-p', '--port', type='int', dest='port', default='4132', metavar='PORT', help='port')
    parser.add_option('-m', '--mode', type='string', dest='mode', default=tags.platform.EXTERNAL, metavar='MODE',
                      help='API mode: "external" or "internal"')
    (options, args) = parser.parse_args()
    mode = options.mode
else:
    import uwsgi
    mode = uwsgi.opt['api_configuration']

set_api_mode(mode)


class APIRootNamespace(NamespaceResource):
    relations = {
        'GET': GetApiInfoHandler,
        'HEAD': HeadApiInfoHandler,
        'ping': res(relations={'GET': GetPing}, hidden=True),
        'v1': V1Namespace,
        'v2': V2Namespace,
    }


router = RegexRouter(APIRootNamespace)

dispatcher = ExternalDispatcher(router) if mode == tags.platform.EXTERNAL else InternalDispatcher(router)

# заполнение публичных ключей TVM при старте сервиса
TVMAuth.register_tvm_clients()
tvm.collect_tvm_pub_keys()

tvm2.update_public_keys(silent_mode_on_errors=False)
tvm2.update_service_tickets()

setup_conductor_cache_update()
setup_hbf_cache_update()
setup_tvm_pub_keys_update()

# Создаем для подписки на обновление конфига
ClientNetworks()

# не удалять, импортируются хуки для uwsgi
if not settings.platform['dynamic_settings']['isolate_zk']:
    print '[dynamic settings] isolation from zookeeper: false'
    from mpfs.platform.dynamic_settings.uwsgi_hooks import (
        preload_auth_settings_and_start_zk_init,
        worker_thread_auth_settings_applier,
        worker_thread_auth_settings_reporter
    )  # noqa
else:
    print '[dynamic settings] isolation from zookeeper: true'

from mpfs.platform.dynamic_settings.cache_writer import update_auth_settings_cache_file
update_auth_settings_cache_file.spool()

application = Flask(__name__)

if PLATFORM_ENABLE_PROFILING:
    from mpfs.platform.profiler import ProfilerMiddleware
    application.wsgi_app = ProfilerMiddleware(application.wsgi_app)


@application.route('/', defaults={'path': ''})
@application.route('/<path:path>',  methods=['GET', 'POST', 'DELETE', 'PATCH', 'PUT', 'OPTIONS', 'HEAD'])
def default(path):
    response = dispatcher.dispatch(request)
    return make_response(response.result if response.result is not None else '', response.status, response.headers)


if __name__ == '__main__':
    application.debug = True
    application.run(host=options.host, port=options.port)
