function count_billing_stats(left, right) {
    params = {'ctime':{}};
    if (left) {
        params['ctime']['$gte'] = left;
    } else {
        params['ctime']['$gte'] = 1375174800;
    }
    if (right) {
        params['ctime']['$lt'] = right;
    }
    
    products = {};
    results  = {"ALL": 0};
    money    = {};
    uids_ok  = {};
    uids     = {};
    users_ok = 0;
    users    = 0;
    
    printjson(params);
    
    db.billing_orders_history.find(params).forEach(
        function (x) {
            uid = x.uid;
            state = x.state;
            auto = x.auto;
            currency = x.currency;
            product = x.pid;
            price = x.price;
            
            if (product != 'test_10GB_for_five_minutes') {
            
                if (x.auto == true) {
                    auto = 'subscr';
                } else {
                    auto = 'single';
                }
            
                if (state == 'success') {
                    if (currency in money) {
                        money[currency] += price;
                    } else {
                        money[currency] = price;
                    }
                    
                    if (product in products) {
                        if (auto in products[product]) {
                            products[product][auto]++;
                        } else {
                            products[product][auto] = 1;
                        }
                    } else {
                        item = {};
                        item[auto] = 1;
                        products[product] = item;
                    }
                    
                    if (!(uid in uids_ok)) {
                        users_ok++;
                        uids_ok[uid] = 1;
                    }
                }
                
                if (!(uid in uids)) {
                    users++;
                    uids[uid] = 1;
                }
                
                if (state in results) {
                    results[state]++;
                } else {
                    results[state] = 1;
                }
                
                results["ALL"]++;
                
            }
        }
    );
    
    
    printjson('= Пользователи, которые пытались =');
    printjson(users);
    printjson('= Пользователи, которые купили ===');
    printjson(users_ok);
    printjson('= Распределение по продуктам =====');
    printjson(products);
    printjson('= Деньги =========================');
    printjson(money);
    printjson('= Заказы =========================');
    printjson(results);
};

/*
https://jira.yandex-team.ru/browse/CHEMODAN-12454

Выбираем всех, у кого автозагрузка кончается до февраля 2014
Ставим дату биллинга + 31536000 секунд
*/
function prolongate_photostream() {
    db.billing_services.find({'pid':'photostream_used', 'btime': {$lt: 1391212800}}).forEach(
        function (x) {
            btime = x.btime + 31536000;
            db.billing_services.update({'_id': x._id}, {'$set': {'btime': btime}});
            print(x._id + ';' + x.uid + ';' + x.btime + ';' + btime);
        }
    );
}
prolongate_photostream();


/*
https://st.yandex-team.ru/CHEMODAN-23350

Удаляем флаг notified всем у кого он очень старый
 */
function billing_drop_notified() {
    db.billing_services.find().forEach(
        function (x) {
            if ('notified' in x) {
                if (x.notified < 1426377600) {
                    db.billing_services.update({'_id': x._id}, {'$unset': {'notified': ''}});
                }
            }
        }
    );
}
billing_drop_notified();

/*
https://jira.yandex-team.ru/browse/CHEMODAN-19160

Оставляем место за автозагрузку навсегда
*/
function eternal_photostream() {
    db.billing_services.find({'pid':'photostream_used'}).forEach(
        function (x) {
            db.billing_services.update({'_id': x._id}, {'$set': {'btime': null}});
            print(x._id + ';' + x.uid);
        }
    );
}
eternal_photostream();


function count_fails(left, right) {
    params = {'ctime': { $gte: left, $lte: right } };
    if ((!left) || (!right)) {
        params = {};
    }
    params['state'] = 'cancelled';
    
   
    results  = {};
    
    db.billing_orders_history.find(params).forEach(
        function (x) {
            status_code = x.status_code;
            
            if (status_code in results) {
                results[status_code]++;
            } else {
                results[status_code] = 1;
            }
        }
    );
    
    printjson('= STATUSES ========================');
    printjson(results);
}



// https://jira.yandex-team.ru/browse/CHEMODAN-11687
function chemodan11687() {
    users = [
"121842608",
"15020368",
"14300544",
"49638000",
"4621456",
"164066256",
"56714976",
"166339776",
"49027440",
"62213440",
"28154128",
"25506016",
"165032880",
"252480",
"63281088",
"16360977",
"6459121",
"42711553",
"269761",
"30131889",
"1260145",
"38144449",
"96855537",
"12965153",
"1633873",
"96427377",
"121246465",
"185346433",
"163357297",
"8913041",
"8755601",
"2496370",
"9253170",
"20872306",
"22559810",
"97488178",
"124749218",
"130162098",
"163122882",
"172311810",
"178005634",
"180576370",
"184369906",
"187353906",
"191994066",
"192015090",
"13375667",
"2728867",
"160900467",
"651635",
"25506355",
"171603891",
"49291027",
"119287251",
"12778979",
"15306579",
"190658003",
"23641043",
"25427011",
"136426004",
"133479988",
"162976452",
"162969764",
"3454756",
"185443124",
"30145444",
"2434580",
"159115716",
"38524708",
"184068532",
"99219876",
"118150660",
"18660820",
"122105572",
"174228324",
"76171668",
"624820",
"187361380",
"166537252",
"66023332",
"25350708",
"5099077",
"155231717",
"31575445",
"184650245",
"5615013",
"478805",
"22524981",
"178521797",
"46412789",
"43122981",
"49158165",
"20845541",
"30657189",
"2382021",
"173777477",
"8628694",
"16484086",
"19736326",
"28714870",
"30379206",
"30831894",
"40924550",
"57094854",
"94557286",
"132199302",
"162978806",
"162988838",
"163020838",
"181285590",
"9416087",
"70992023",
"26691975",
"26100391",
"165158071",
"157896327",
"45735",
"107864999",
"38598759",
"28331575",
"26100823",
"92772935",
"77140487",
"156297511",
"173973032",
"110488",
"85529976",
"15260328",
"29433816",
"52124104",
"1094152",
"27213992",
"108593768",
"160733096",
"809",
"64051273",
"29230489",
"8902425",
"126029017",
"16262073",
"32163097",
"22439161",
"46780265",
"41699273",
"1465577",
"377945",
"181664617",
"1861097",
"163453929",
"18021017",
"89433065",
"34342537",
"190338665",
"188199257",
"162965977",
"7345610",
"15284474",
"16011578",
"32447642",
"36152618",
"45521658",
"55629242",
"69212490",
"70603994",
"122159482",
"163968362",
"173816586",
"174213210",
"188403114",
"160636507",
"163215755",
"4269035",
"25528347",
"79963",
"6554395",
"137992891",
"42995499",
"106605083",
"65467",
"175774907",
"37316747",
"10040251",
"57426123",
"79576555",
"106359211",
"5421067",
"5364668",
"6845772",
"6999788",
"15340588",
"49361052",
"51205020",
"54174972",
"74333324",
"78518140",
"83080460",
"124557020",
"160636060",
"183602844",
"185863564",
"185689773",
"9777565",
"50253",
"164743021",
"185989565",
"25967757",
"56582669",
"19175117",
"85355021",
"5630333",
"36053917",
"173484109",
"177492013",
"158353421",
"50435677",
"191068493",
"32374333",
"53417421",
"69041869",
"1379901",
"5170605",
"90429069",
"171228606",
"178550638",
"21349134",
"58897054",
"43815694",
"54096030",
"176753039",
"86189679",
"160105423",
"1207743",
"241199",
"15097423",
"9320383",
"156370815",
"29256239",
"56495167",
"190571951",
"18939327",
"163939887",
"191996239",
"162392975",
"6478447"
    ];
    
    for (i in users) {
        uid = users[i];
        printjson(uid);
        db.billing_services.update({'uid': uid, 'pid': 'music_dec_2012'}, {$set: {'btime': null}});
    }
}
