// https://jira.yandex-team.ru/browse/CHEMODAN-5524
// посчитать количество разновсяческих инвайтов
function count_invite_statistics() {
    users = {};
    ucount = 0;
    activated = 0;
    waiting = 0;
    nospace = 0;
    suspicious = 0;
    ok = 0;
    
    db.invite_mpfs_referrals.find().forEach(
        function(x) {
            referral = x.ref;
            state = x.state;
            
            if (!(referral in users)) {
                users[referral] = 1;
                ucount++;
            }
            
            if (state == 'wait') {
                waiting++;
            } else if (state == 'ok') {
                ok++;
            } else if (state == 'nospace') {
                nospace++;
            } else if (state == 'suspicious') {
                suspicious++;
            }
            
            activated++;
        }
    )

    printjson('= TOTAL ========================')
    printjson(['activated', activated]);
    printjson(['waiting', waiting])
    printjson(['ok', ok])
    printjson(['suspicious', suspicious])
    printjson(['nospace', nospace])
    printjson('= AVERAGE ======================')
    printjson(['activated', activated/ucount]);
    printjson(['waiting', waiting/ucount])
    printjson(['ok', ok/ucount])
    printjson(['suspicious', suspicious/ucount])
    printjson(['nospace', nospace/ucount])
    printjson('================================')
}

function count_invite_statistics_for_countries() {
    result = {}
    
    db.invite_mpfs_referrals.find().forEach(
        function(x) {
            referral = x.ref;
            state = x.state;
            info = db.user_index.findOne({_id: referral});
            locale = info['locale'];
            if (!result[locale]) {
                result[locale] = {
                    'ok': 0,
                    'activated': 0
                }
            }
            
            if (state == 'ok') {
                result[locale]['ok']++;
            } 
            
            result[locale]['activated']++;
        }
    )

    var tuples = [];
    for (var key in result) tuples.push(key);
    tuples.forEach(
        function(str) {
            printjson('================================');
            printjson(str);
            printjson(['activated', result[str]['activated']]);
            printjson(['ok', result[str]['ok']])
        })
}

function count_invite_statistics_for_countries_ru_tr(left, right) {
    result = {};
    params = {'mtime': { $gte: left, $lte: right } };
    
    if ((!left) || (!right)) {
        params = {};
    }
    
    db.invite_mpfs_referrals.find(params).forEach(
        function(x) {
            referral = x.ref;
            state = x.state;
            info = db.user_index.findOne({_id: referral});
            locale = info['locale'];
            
            if (locale != 'tr') {
                locale = 'ru';
            }
            
            if (!result[locale]) {
                result[locale] = {'ok': 0, 'activated': 0};
            }
            
            if (state == 'ok') {
                result[locale]['ok']++;
            } else {
                result[locale]['activated']++;
            }
        }
    )
    
    var tuples = [];
    for (var key in result) tuples.push(key);
    tuples.forEach(
        function(str) {
            printjson('================================');
            printjson(str);
            printjson(['activated', result[str]['activated']]);
            printjson(['ok', result[str]['ok']])
        }
    )
}


function count_invite_statistics_sent_ru_tr(left, right) {
    result = {};
    users = {};
    params = {'v': { $gte: left, $lte: right } };
    
    if ((!left) || (!right)) {
        params = {};
    }
    
    db.invite_mpfs_sent.find(params).forEach(
        function(x) {
            referral = x.uid;
            
            info = db.user_index.findOne({_id: referral});
            
            if ((info)&& (info['locale'])) {
                locale = info['locale'];
                
                if (locale != 'tr') {
                    locale = 'ru';
                }
                
                if (!result[locale]) {
                    result[locale] = {'sent': 0, 'uc': 0};
                }
                
                result[locale]['sent']++;
            
                if (!users[referral]) {
                    users[referral] = 1;
                    result[locale]['uc']++;
                }
                
            }
        }
    )
    
    printjson([result]);
}


// Общеупотребительная функция сортировки хеша по значению
function _sort_dict(obj){
    var tuples = [];

    for (var key in obj) tuples.push([key, obj[key]]);
    
    tuples.sort(function(a, b) {
        a = a[1];
        b = b[1];
    
        return a < b ? -1 : (a > b ? 1 : 0);
    });
    
    return tuples;
}


// Найти топов
function find_top_users() {
    users = {};
    
    db.invite_mpfs_referrals.find().forEach(
        function(x) {
            referral = x.ref;
            state = x.state;
            
            if (!(referral in users)) {
                users[referral] = 1;
            } else {
                users[referral]++;
            }
        }
    )
    
    tuples = _sort_dict(users);
    
    for (var i = 0; i < tuples.length; i++) {
        var key = tuples[i][0];
        var value = tuples[i][1];
    
        printjson([key, value])
    }
}

// Найти отправляемость
function count_sent_users(prov) {
    sent  = {};
    count = 0;
    
    db.invite_mpfs_sent.find().forEach(
        function(x) {
            provider = x.p;
            uid = x.uid;
            
            if (provider == prov) {
                if (!(uid in sent)) {
                    sent[uid] = 1;
                    count++;
                } 
            }
        }
    );
    
    printjson([count]);
}

/*
https://jira.yandex-team.ru/browse/CHEMODAN-8596

Нужна следующая информация по реферальной системе за все время (укажи, пожалуйста, дату, с которой есть данные):
сколько уникальных пользователей разослало приглашения
сколько всего приглашений было разослано
сколько приглашений было активировано
как распределяются по направлениям отправки приглашения вообще
как распределяются по направлениям отправки непринятые приглашения

*/

function invite_sended_statistics(left, right) {
    users = {};
    user_count = 0;
    directions = {};
    total_sent = 0;
    
    params = {'v': { $gte: left, $lte: right } };
    if ((!left) || (!right)) {
        params = {};
    }
    
    db.invite_mpfs_sent.find(params).forEach(
        function(x) {
            provider = x.p;
            address = x.u;
            uid = x.uid;
            
            total_sent++;
            
            direction = '';
            if (provider == 'email') {
                parts = address.split('@');
                direction = parts[1];
            } else {
                direction = provider;
            }
            if (!(direction in directions)) {
                directions[direction] = 1;
            } else {
                directions[direction]++;
            }
            
            if (!(uid in users)) {
                users[uid] = 1;
                user_count++;
            }
        }
    )
    
    tuples = _sort_dict(directions);
    
    for (var i = 0; i < tuples.length; i++) {
        var key = tuples[i][0];
        var value = tuples[i][1];
    
        printjson([key, value]);
    }
    
    printjson(['=========================']);
    printjson([total_sent]);
    printjson([user_count]);
    
}


function invite_activated_statistics() {
    
}