
// Общеупотребительная функция сортировки хеша по значению
function _sort_dict(obj){
    var tuples = [];

    for (var key in obj) tuples.push([key, obj[key]]);
    
    tuples.sort(function(a, b) {
        a = a[1];
        b = b[1];
    
        return a < b ? -1 : (a > b ? 1 : 0);
    });
    
    return tuples;
}

// ===========

// Посчитать суммарно пользовательские состояния
function count_user_states(state_name) {
    result = 0;
    db.disk_info.find().forEach(
        function (x) {
            if (x.key == '/states/disk/global') {
                data = x.data;
                var len=data.length;
                for(var i=0; i<len; i++) {
                    var value = data[i];
                    if (value[0] == state_name) {
                        result++;
                    }
                }
            }
        }
    );
    return result;
}


// Посчитать увеличения места по space_subscibes
function count_user_space_subscribes() {
    var reasons = {};
    db.space_subscribes.find().forEach(
        function (x) {
            reason = x.reason;
            if( reason in reasons) {
                reasons[reason]++;
            } else {
                reasons[reason] = 1;
            }
            
        }
    );
    
    
    function _sort_dict(obj){
        var tuples = [];
    
        for (var key in obj) tuples.push([key, obj[key]]);
        
        tuples.sort(function(a, b) {
            a = a[1];
            b = b[1];
        
            return a < b ? -1 : (a > b ? 1 : 0);
        });
        
        return tuples;
    }
    
    tuples = _sort_dict(reasons);
    
    for (var i = 0; i < tuples.length; i++) {
        var key = tuples[i][0];
        var value = tuples[i][1];
    
        printjson([key, value])
    }
}

// Напечатать юзеров для состояния
function print_users_for_state(state_name) {
    var uids = [];
    db.disk_info.find({'key':"/states/disk/global"}).forEach(
        function (x) {
            data = x.data;
            var len=data.length;
            for(var i=0; i<len; i++) {
                var value = data[i];
                if (value[0] == state_name) {
                    print(x.uid);
                }
            }
        }
    );
}

// Напечатать количество юзеров с состоянием
function print_users_count_for_state(state_name) {
    var uids = [];
    result = 0;
    db.disk_info.find({'key':"/states/disk/global"}).forEach(
        function (x) {
            data = x.data;
            var len=data.length;
            for(var i=0; i<len; i++) {
                var value = data[i];
                if (value[0] == state_name) {
                    result++;
                }
            }
        }
    );
    print(result)
}

// Посчитать все-все-все состояния
function count_all_user_states(namespace) {
    states = {};
    if (!namespace) {
        namespace = 'global';
    }
    search_key = '/states/disk/'.concat(namespace);
    printjson(search_key);
    
    db.disk_info.find().forEach(
        function (x) {
            if (x.key == search_key) {
                data = x.data;
                var len=data.length;
                for(var i=0; i<len; i++) {
                    var value = data[i];
                   
                    if (value[0] in states) {
                        states[value[0]]++;
                    } else {
                        states[value[0]] = 1;
                    }
                    
                }
            }
        }
    );
    
    tuples = _sort_dict(states);
    
    for (var i = 0; i < tuples.length; i++) {
        var key = tuples[i][0];
        var value = tuples[i][1];
    
        printjson([key, value]);
    }    
}



// Посчитать средний размер файла 
function average_file_size() {
    numfiles = 0;
    totalsize = 0;
    db.user_data.find({'type':'file'}).forEach(
        function (x) {
            mb_size = parseFloat((x.data.size/1024/1024).toFixed(1));
            totalsize += mb_size;
            numfiles++;
        }
    );
    result = (totalsize/numfiles).toFixed(2);
    return result;
}

// https://jira.yandex-team.ru/browse/CHEMODAN-5104
// - сколько из юзеров загрузили хоть одну mp3-шку?
// - сколько всего загрузили mp3-шек?
// - сколько mp3-шек у рекордсменов по загрузкам? то есть сколько максимум mp3 на одном аккаунте?
function mp3_stat() {
    users = {};
    count = 0;
    total_count = 90000000;
    for (var i = 0; i < total_count; i = i + 1000000) { 
        db.user_data.find({'type':'file'}).skip(i).limit(1000000).forEach(
            function (x) {
                if ((x.key !== undefined) && (x.key !== null)) {
                    fname = x.key;
                    uid = x.uid;
                    chunks = fname.split('.');
                    extension = chunks[chunks.length-1];
                    if (extension == 'mp3') {
                        count++;
                        if( uid in users) {
                            users[uid]++;
                        } else {
                            users[uid] = 1;
                        }
                    }
                }
            }
        );
        printjson([i, total_count]);
    }
    
    function sortObj(theObj){
        var sortable = [];
        for(var i in theObj){
            sortable.push([i, theObj[i]]);
        }
        sortable.sort(function(a,b){
            return b[1] - a[1];
        });
        
        return sortable;
    }
    
    sorted = sortObj(users)
    
    printjson(['========================']);
    printjson(['users with one or more mp3s', sorted.length]);
    printjson(['total mp3s count', count]);
    printjson(['========================']);
    
    top = 10;
    if (sorted.length < 10) {
        top = sorted.length;
    }
    for (var i = 0; i < top; i = i + 1) {
        printjson([sorted[i][0], sorted[i][1]])
    }
}


// Посчитать средний размер пользователя
function average_user_size() {
    numusers  = db.user_index.find().count();
    totalsize = 0;
    db.user_data.find({'type':'file'}).forEach(
        function (x) {
            mb_size = parseFloat((x.data.size/1024/1024).toFixed(1));
            totalsize += mb_size;
        }
    );
    result = (totalsize/numusers).toFixed(2);
    return result;
}

// Посчитать используемые расширения
function top_extensions(){
    
    extensions = {};
    total_count = 10000000;
    for(var i = 0; i < total_count; i = i + 10000000) {
        printjson(['---', i, total_count, '---']);
        db.user_data.find().skip(i).limit(10000000).forEach(function(x) {
            if (x.type == 'file') {
                ext = x.key.split('.').pop().toLowerCase();
                if(!ext.match('/')) {
                    if( ext in extensions) {
                        extensions[ext]++;
                    } else {
                        extensions[ext] = 1;
                    }
                }
            }
        })
    }
    
    tuples = _sort_dict(extensions);
    
    for (var i = 0; i < tuples.length; i++) {
        var key = tuples[i][0];
        var value = tuples[i][1];
    
        printjson([key, value])
    }
        
}


// Посчитать активных подписанных пользователей
function count_active_users(timestamp){
    users = {};
    count = 0;
    total = 0;
    ts = parseInt(timestamp)
    db.sys_data.find({'key': /\.sys\/xiva\//, 'data.ctime': {$gt: ts}}).forEach(
        function (x) {
            uid = x.uid;
            if (users[uid] === undefined){
                users[uid] = 1;
                count++;
                total++;
            } else {
                users[uid]++;
                total++;
            }
        }
    );
    printjson([count, total]);
    return count;
}

// Подсчет опубликованных файлов по расширениям
function count_shared_files() {
    all = {};
    total_count = db.link_data.find({
        'type' : 'file'
    }).count();
    for(var i = 0; i < total_count; i = i + 2000) {
        db.link_data.find({
            'type' : 'file'
        }).skip(i).limit(2000).forEach(function(x) {
            ext = x.data.tgt.split('.').pop().toLowerCase();
            if(!ext.match('/')) {
                if( ext in all) {
                    all[ext] = all[ext] + 1;
                } else {
                    all[ext] = 1;
                }
            }
        })
    }
    return all
}

// Подсчет пользователей, ограниченных по трафику
// https://jira.yandex-team.ru/browse/CHEMODAN-6790
function count_download_limited_users() {
    count = 0;
    db.disk_info.find({'key':'/download_traffic', 'data.bytes': {$gt: 0}, 'data.ctime': {$gt: 1348570800}}).forEach(
        function(x) {
            limit = 0;
            db.disk_info.find({'key':'/limit', 'uid': x.uid}).forEach(
                function(y) {
                    limit = y.data;
                }
            );

            if (x.data.bytes > limit*2) {
                count++;   
            }
        }
    );
    printjson({'count': count});
}

// Посчитать юзеров, у которых состояние не дублируется в space_subscribes
function find_users_without_space_subscribes_state(state_name) {
    users = [];
    
    db.disk_info.find({'key':"/states/disk/global"}).forEach(
        function (x) {
            data = x.data;
            uid = x.uid;
            var len=data.length;
            for(var i=0; i<len; i++) {
                var value = data[i];
                if (value[0] == state_name) {
                    found = db.space_subscribes.findOne({'uid': uid, 'reason': state_name});
                    if (!found) {
                        users.push(uid);
                    }
                }
            }
        }
    );
    printjson(users);
    printjson(users.length);
}


// Посчитать объемы дисков у тех, кто с фотостримом
// https://jira.yandex-team.ru/browse/CHEMODAN-12214
function collect_photostream_stat() {    
    db.billing_services.find({'pid':'photostream_used'}).forEach(
        function (x) {
            uid  = x.uid;
            
            i = db.disk_info.findOne({'uid': uid, 'key':'/total_size'});
            if (i) {
                total = i.data;
            }
            
            i = db.disk_info.findOne({'uid': uid, 'key':'/trash_size'});
            if (i) {
                trash = i.data;
            }
            
            i = db.disk_info.findOne({'uid': uid, 'key':'/limit'});
            if (i) {
                limit = i.data;
            }
            
          
            print(uid + ';' + limit + ';' + total + ';' + trash + ';' + (trash+total));
        }
    );
}
collect_photostream_stat();


// https://jira.yandex-team.ru/browse/CHEMODAN-14234
// считаем всех, кому выдали 200 гб
function collect_lucky(){
    db.billing_services.find({'pid': '20131201_install_fail'}).forEach(
        function (x) {
            uid  = x.uid;
            
            i = db.disk_info.findOne({'uid': uid, 'key':'/total_size'});
            if (i) {
                total = i.data;
            }
            
            i = db.disk_info.findOne({'uid': uid, 'key':'/trash_size'});
            if (i) {
                trash = i.data;
            }
            
            i = db.disk_info.findOne({'uid': uid, 'key':'/limit'});
            if (i) {
                limit = i.data;
            }
            
            notified = 0;
            cron = db.disk_info.findOne({'uid': uid, 'key': '/states/disk/cron'});
            if (cron) {
                data = cron.data;
                for(var i=0; i<data.length; i++) {
                    nstamp = data[i][1];
                    if (nstamp > notified) {
                        notified = nstamp;
                    }
                }
            }
            
            print(uid + ';' + limit + ';' + total + ';' + trash + ';' + (trash+total) + ';' + notified);
        }
    );
}
collect_lucky();



// https://jira.yandex-team.ru/browse/CHEMODAN-15372
// считаем всех с акцией Самсунга 201309
// http://h.yandex.net/?http%3A%2F%2Fhelp.yandex.ru%2Fdisk%2Fdesktop%2Fbonus-space.xml%2350-samsung
function collect_samsung201309(){
    db.dist_samsung_201309.find().forEach(
        function (x) {
            if (x.state == 'ok') {
                uid  = x.uid;
                
                i = db.disk_info.findOne({'uid': uid, 'key':'/total_size'});
                if (i) {
                    total = i.data;
                }
                
                i = db.disk_info.findOne({'uid': uid, 'key':'/trash_size'});
                if (i) {
                    trash = i.data;
                }
                
                i = db.disk_info.findOne({'uid': uid, 'key':'/limit'});
                if (i) {
                    limit = i.data;
                }
                
                print(uid + ';' + limit + ';' + total + ';' + trash + ';' + (trash+total));
            }
        }
    );
}
collect_samsung201309();


// https://jira.yandex-team.ru/browse/CHEMODAN-15372
// считаем всех с акцией Самсунга 250 гб
// http://help.yandex.ru/disk/desktop/bonus-space.xml#250-samsung
function collect_samsung_250(){
    db.dist_samsung_ub.find().forEach(
        function (x) {
            if ((x.state == 'ok') && (x.uid != null)) {
                uid  = x.uid;
                
                i = db.disk_info.findOne({'uid': uid, 'key':'/total_size'});
                if (i) {
                    total = i.data;
                }
                
                i = db.disk_info.findOne({'uid': uid, 'key':'/trash_size'});
                if (i) {
                    trash = i.data;
                }
                
                i = db.disk_info.findOne({'uid': uid, 'key':'/limit'});
                if (i) {
                    limit = i.data;
                }
                
                print(uid + ';' + limit + ';' + total + ';' + trash + ';' + (trash+total));
            }
        }
    );
}
collect_samsung_250();


// Посчитать сколько юзеров что-то имеет в корзине
function count_users_with_trash() {
    var result = 0;
    var counter = 0;
    var last_check = 0;
    var total = db.disk_info.find().count();
    db.disk_info.find().forEach(
        function (x) {
            counter++;
            if (x.key == '/trash_size') {
                data = x.data;
                if (data > 0) {
                    result++;
                }
            }
            if (counter >= (last_check + 1000000)) {
                last_check = counter;
                print(last_check + ' from ' + total + ':' + result);
            }
        }
    );
    print('------')
    print(result);
}

