// Общеупотребительная функция сортировки хеша по значению
function _sort_dict(obj, fld){
    var tuples = [];

    if (fld === undefined) {
        for (var key in obj) tuples.push([key, obj[key]]);
    } else {
        for (var key in obj) tuples.push([key, obj[key][fld], obj[key]]);    
    }
    
    tuples.sort(function(a, b) {
        a = a[1];
        b = b[1];
    
        return a < b ? -1 : (a > b ? 1 : 0);
    });
    
    return tuples;
}

// Посчитать по группам кол-во участников и размеры
function count_users_sizes() {
    groups = {};
    users_in_groups = {};
    total_users = 0;
    total_groups = 0;
    
    db.groups.find().forEach(
        function (x) {
            count = db.group_links.find({'gid': x._id}).count();
            groups[x._id] = {
                'owner': x.owner,
                'path': x.path,
                'size': x.size,
                'users': count
            };
            
            if( count in users_in_groups) {
                users_in_groups[count]++;
            } else {
                users_in_groups[count] = 1;
            }
            
            total_users += count;
            total_groups++;
        }
    );
    
    sorted_groups = _sort_dict(groups, 'users');
    sorted_users_in_groups = _sort_dict(users_in_groups, undefined);
    
    printjson([sorted_groups]);
    printjson(['=======================================']);
    printjson([sorted_users_in_groups]);
    printjson([total_users / total_groups]);
}

// https://jira.yandex-team.ru/browse/CHEMODAN-8679
function count_share_users(){
    users = {};
    count = 0;
    
    db.groups.find().forEach(
        function(x) {
            uid = x.owner;
            if (!(uid in users)) {
                users[uid] = 1;
                count++;
            }
        }
    );
    
    db.group_links.find().forEach(
        function (x) {
            uid = x.uid;
            if (!(uid in users)) {
                users[uid] = 1;
                count++;
            }
        }
    );
    
    printjson(count);
}

function count_links_amount_per_user(){
    var links = {};
    var amounts = {};

    db.group_links.find().forEach(
        function (x) {
            uid = x.uid;
            if (!(uid in links)) {
                links[uid] = 1;
            } else {
                links[uid] += 1;
            }
        }
    );

    for (var uid in links) {
        var v = links[uid];
        if (!(v in amounts)) {
            amounts[v] = 1;
        } else {
            amounts[v] += 1;
        }
    }

    printjson(amounts);
}
