#!/usr/bin/python
# -*- coding: utf-8 -*-
from datetime import datetime, timedelta

import yt.wrapper as yt

import mpfs.engine.process
from nile.api.v1 import clusters
from qb2.api.v1 import extractors as se
from qb2.api.v1 import filters as sf

mpfs.engine.process.setup_admin_script()
from mpfs.config import settings
from mpfs.common.util import mailer


def generate_yt_table(dt, job_root, result_table):
    yttoken = open("/etc/yandex/disk-stat-token", "r").read().strip()
    yt.config['token'] = yttoken
    yt.config['proxy']['url'] = settings.mrstat['yt_proxy']
    cluster = clusters.Hahn(token=yttoken).env(templates=dict(job_root=job_root))
    job = cluster.job()
    src_log = job.table('statbox/ydisk-mpfs-default-log/' + dt)

    records = src_log.qb2(
        log='generic-tskv-log',
        fields=[se.log_fields('timestamp', 'host', 'worker', 'message', 'request_id', 'pid', 'source_uri', 'ycrid')],
        filters=[sf.search('message', r'handle_billing_.*task_status: FAIL')]
    )

    records.unique('request_id').put(result_table)
    job.run()
    return len(list(yt.read_table('//' + result_table, format=yt.JsonFormat())))


def send_mail(dt, result_table_name, total_lines):
    params = {
        'locale': 'ru',
        'title': 'Daily billing errors ' + dt,
        'body': 'https://yt.yandex-team.ru/%s/#page=navigation&path=//%s\n\nTotal: %s'
                % (settings.mrstat['yt_proxy'].split('.')[0], result_table_name, total_lines)
    }

    mailer.send(
        'disk-mpfs-alarm@yandex-team.ru',
        'diskSupport',
        params,
        sender_email=settings.smtp['from_yandex-team_ru'],
    )


if __name__ == '__main__':
    if settings.mrstat['enabled']:
        yesterday = (datetime.now() - timedelta(days=1)).strftime('%Y-%m-%d')
        job_root = 'home/disk-stat'
        result_table_name = job_root + '/billing_errors/' + yesterday
        total_lines = generate_yt_table(yesterday, job_root, result_table_name)
        send_mail(yesterday, result_table_name, total_lines)
    else:
        print "Skip task, mrstat is not enabled"
