#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

Скрипт удаления дубликатов в закладках браузера
https://st.yandex-team.ru/CHEMODAN-19252

"""
import optparse
import os
import sys
import multiprocessing
import datetime
import urllib2
import shelve
import traceback

from datetime import date, timedelta

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()

from mpfs.common.util import iterdbuids

db = mpfs.engine.process.dbctl().database()

BATCH_SIZE = 1000


def add_user(uid):
    log.info("Add user %s" % uid)
    db.sync_resync.update({'uid': uid}, {'uid': uid, 'status': 'initial'}, upsert=True)


def request_resync(uid):
    now = datetime.datetime.now()
    urllib2.urlopen('http://localhost:8090/migrate_datatype/dummy/%s/32904?resync=true' % uid, '')
    db.sync_resync.update(
        {
            'uid': uid,
            'status': 'initial',
        },
        {
            '$set': {
                'status': 'resync_requested',
                'resync_requested': now.strftime("%Y%m%d"),
            }
        }
    )


def check_resync(updated_file):
    now = datetime.datetime.now()
    for user in db.sync_resync.find({'status': 'resync_requested'}):
        uid = user['uid']
        if uid in updated_file['uids']:
            try:
                db.sync_resync.update(
                    {
                        'uid': uid,
                        'status': 'resync_requested',
                    },
                    {
                        '$set': {
                            'status': 'resynced',
                            'resynced': now.strftime("%Y%m%d"),
                        }
                    }
                )
                log.info("Uid: %s resynced" % uid)
            except Exception:
                log.error(traceback.format_exc())


def start_deduplicating(uid):
    now = datetime.datetime.now()
    user = db.sync_resync.find_one({'uid': uid})
    if user['status'] == 'resynced':
        db.sync_resync.update(
            {
                'uid': uid,
            },
            {
                '$set': {
                    'status': 'deduplicating',
                },
            }
        )
        urllib2.urlopen('http://localhost:8090/migrate_datatype/remove_duplicates/%s/32904?resync=false' % uid, '')
        db.sync_resync.update(
            {
                'uid': uid,
            },
            {
                '$set': {
                    'status': 'deduplicated',
                    'deduplicated': now.strftime("%Y%m%d"),
                },
            }
        )


def reset_deduplicating(uid):
    db.sync_resync.update(
        {
            'status': 'deduplicating',
        },
        {
            '$set': {
                'status': 'resynced',
            },
        }
    )


option_list = (
    optparse.Option('-a', '--add_users', action='store_true', dest='add_users', default=False,
                    help='Add all users to sync_resync collection'),
    optparse.Option('-r', '--request_resync', action='store_true', dest='request_resync', default=False,
                    help='Request resync for users in sync_resync collection'),
    optparse.Option('-c', '--check_resync', action='store_true', dest='check_resync', default=False,
                    help='Read resynced users from file and mark them in DB'),
    optparse.Option('-s', '--start-deduplicating', action='store_true', dest='start_deduplicating', default=False,
                    help='Start deduplicating process'),
    optparse.Option('-w', '--wait-period', action='store_true', dest='wait_period', default=False,
                    help='Waiting period to start deduplicating'),
    optparse.Option('-e', '--reset-deduplicating', action='store_true', dest='reset_deduplicating', default=False,
                    help='Reset deduplicating process'),
    optparse.Option('-u', '--updated-file', type='string', action='store',
                    dest='updated_file', help='File with uids, having get_updated request in logs'),
    optparse.Option('-t', '--test-checking-all-uids', action='store_true', dest='test_checking', default=False,
                    help='Run deleting duples for all uids in db'),
    optparse.Option('-l', '--limit', action='store', type='int', dest='limit', default=10000,
                    help='Add all users to sync_resync collection'),
    optparse.Option('-f', '--file', type='string', action='store',
                    default="/tmp/mpfs-browser-deduplicate-cache",
                    dest='file', help='File where to store local uid cache. Default is "%default".'),
    optparse.Option('-p', '--processes', type='int', action='store', dest='processes', default=None,
                    help='Number of processes. Default is your CPU count: %d.' % multiprocessing.cpu_count()),
)

usage = "usage: sudo /usr/sbin/%prog -h"

if __name__ == "__main__":
    parser = optparse.OptionParser(option_list=option_list)
    (options, args) = parser.parse_args()
    if options.add_users:
        iterdbuids.run(
            add_user,
            None,
            options.file,
            max_processes=options.processes,
            collection="sync_index",
            user_type=None,
        )
    elif options.request_resync:
        if os.path.isfile(options.file):
            os.remove(options.file)

        spec = {'status': 'initial'}
        iterdbuids.run(
            request_resync,
            None,
            options.file,
            max_processes=options.processes,
            limit=options.limit,
            collection="sync_resync",
            spec=spec,
            user_type=None,
        )
    elif options.check_resync:
        if not options.updated_file:
            print "Check_resync mode need 'updated_file' option"
        else:
            uids_filecache = shelve.open(options.file, writeback=True)
            uids_filecache['uids'] = []
            with open(options.updated_file, 'rU') as f:
                for uid in f:
                    uid = uid.rstrip()
                    uids_filecache['uids'].append(uid)
            check_resync(uids_filecache)
    elif options.start_deduplicating:
        if not options.wait_period:
            print "Wait period option needed"
        else:
            if os.path.isfile(options.file):
                os.remove(options.file)
            wait_period = int(options.wait_period)
            if options.test_checking:
                spec = {'status': 'resynced'}
            else:
                d = date.today() - timedelta(days=wait_period)
                spec = {'status': 'resynced', 'resynced': {'$lt': d.strftime("%Y%m%d")}}
            iterdbuids.run(
                start_deduplicating,
                None,
                options.file,
                max_processes=options.processes,
                spec=spec,
                collection='sync_resync',
                user_type=None,
            )
    elif options.reset_deduplicating:
        iterdbuids.run(
            reset_deduplicating,
            None,
            options.file,
            max_processes=options.processes,
            collection="sync_resync",
            user_type=None,
            spec={'status': 'deduplicating'},
        )
    else:
        print "usage: sudo /usr/sbin/%prog -h"