#!/usr/bin/python
# -*- coding: utf-8 -*-
import sys
import operator
import traceback
import time
import itertools
import re

from optparse import OptionParser, Option
from collections import defaultdict

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()

import mpfs.common.util.config
import mpfs.common.util.dbnaming

from mpfs.common.util.progress_bar import ProgressBar
from mpfs.common.util import time_parse, format_dict_table
from mpfs.metastorage.mongo.collections.changelog import ChangelogCollection

changelog = ChangelogCollection()

usage = "usage: sudo /usr/sbin/%prog -h"

option_list = (
    Option(
        '-u', '--uid',
        action='store',
        dest='uid',
        type='string',
        default=None,
        help='Specify uid'),
    Option(
        '-d', '--date',
        action='store',
        dest='date',
        help='YYYY-MM-DD or timestamp or days before, remove all records before this date'),
    Option(
        '-s', '--show',
        action='store_true',
        dest='show', 
        default=True,
        help='show items count per user')
    )
    
parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

class ChangelogManager(object):

    def __init__(self, uid, date):
        self.uid = uid
        self.date = date 
    
    def request_params(self, uid=None, date=None):
        result = {}
        if uid:
            result.update({'uid': uid})
        if date:
            date = int(str('%f' % date).replace('.', ''))
            result.update({'version' : {'$lte' : date}})
        return result

    def show(self):
        result = defaultdict(dict)
        request_params = self.request_params(self.uid, self.date)
        res = changelog.find(request_params)
        count = res.count()
       
        for k, g in itertools.groupby(
            sorted(res, key=operator.itemgetter('uid')),
            operator.itemgetter('uid')):
            result[k] = len(list(g))
            
        res = sorted(
            map(lambda (k, v): dict(uid=k, count=v), result.iteritems()),
            key=lambda x: x['uid']
        )
        
        print format_dict_table(res, ['uid', 'count'])
        print 'total: %s' % count



if __name__ == "__main__":
    if options.date:
        if options.date.isdigit():
            date = int(options.date)
            if date < 1000000000:
                date = time.time() - 24 * 3600 * date
        else:
            date = time_parse(options.date + ' 00:00:00')
    else:
        date = int(time.time())
        
    if not options.uid:
        parser.print_help()
        sys.exit(0)
        
    obj = ChangelogManager(options.uid, date)
    print time.ctime(date)
    obj.show()
