# -*- coding: utf-8 -*-

import os
import json
import requests

import warnings
warnings.filterwarnings('ignore')

# файл, в который записывается версия устанавливаемого пакета апи перед выполнением
# task do или task preinstall в executer
INSTALLED_API_VERSION_FILE = '/var/cache/disk_deploy/python-mpfs-api.txt'
# файл, в который записывается версия устанавливаемого пакета mpfs перед выполнением
# task do или task preinstall в executer
INSTALLED_DISK_VERSION_FILE = '/var/cache/disk_deploy/python-mpfs-disk.txt'


def compare_disk_version():
    response = requests.get('http://localhost/version')
    http_version = response.content.replace('"', '')
    with open(INSTALLED_DISK_VERSION_FILE) as f:
        installed_version = f.read().strip()
        if http_version == installed_version:
            print "Versions are equal [disk/http/80]: %s." % http_version
        else:
            print "Versions are not equal [disk/http/80]: %s != %s." % (http_version, installed_version)
            exit(1)


def compare_api_version(url):
    response = requests.get(url, verify=False)
    http_version = json.loads(response.content)['build']
    with open(INSTALLED_API_VERSION_FILE) as f:
        installed_version = f.read().strip()
        if http_version == installed_version:
            print "Versions are equal [%s]: %s." % (url, http_version)
        else:
            print "Versions are not equal [%s]: %s != %s." % (url, http_version, installed_version)
            exit(1)


def main():
    disk_version_file_exists = os.path.exists(INSTALLED_DISK_VERSION_FILE)
    api_version_file_exists = os.path.exists(INSTALLED_API_VERSION_FILE)

    if not disk_version_file_exists and not api_version_file_exists:
        print 'Could not find %s or %s.' % (INSTALLED_DISK_VERSION_FILE, INSTALLED_API_VERSION_FILE)
        exit(1)

    if disk_version_file_exists:
        compare_disk_version()
    elif api_version_file_exists:
        compare_api_version('http://localhost:8080')
        compare_api_version('https://localhost')

if __name__ == '__main__':
    main()
