#!/usr/bin/python
# -*- coding: utf-8 -*-
from optparse import OptionParser, Option
import traceback

usage = "usage: sudo /usr/sbin/%prog -h"
    
option_list = (
    Option(
        '-i', '--id',
        action='store',
        dest='item_id',
        type='string',
        default=None,
        help='Specify _id'
    ),
    Option(
        '-u', '--uid',
        action='store',
        dest='uid',
        type='string',
        default=None,
        help='Specify uid'
    ),
    Option(
        '-c', '--collection',
        action='store',
        dest='collection',
        default=None,
        help="Specify collection",
    ),
    Option(
        '-v', '--value',
        action='store',
        dest='value',
        default=None,
        help="Specify value",
    ),
)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
log = mpfs.engine.process.get_default_log()

from mpfs.metastorage.mongo.util import decompress_data, compress_data
from mpfs.core.social.publicator import Publicator
from mpfs.core.filesystem.base import Filesystem
from mpfs.core.address import Address
from bson.objectid import ObjectId
from bson.errors import InvalidId

publicator = Publicator()
db = mpfs.engine.process.dbctl().database()

def run():
    item = db[options.collection].find_one({'_id':options.item_id})
    if not item:
        try:
            item = db[options.collection].find_one({'_id':ObjectId(options.item_id)})
        except InvalidId:
            pass

    def process_one(item, collection):
        mpfs.engine.process.reset_cached()
        
        spec = {
                '_id' : item['_id'],
                'uid' : item['uid'],
                'version' : item['version'],
                }
        zdata = item.pop('zdata')
        data = decompress_data(zdata)
        changed = 0
        
        if int(data['meta']['drweb']) != int(options.value):
            data['meta']['drweb'] = int(options.value)
            item['zdata'] = compress_data(data)
            db[collection].update(spec, item)
            log.info('%s item updated' % item['_id'])
            changed = 1
            
        if int(options.value) == 2:
            fs = Filesystem()
            address = Address.Make(item['uid'], item['key'])
            resource = fs.resource(item['uid'],  address.id)
            if hasattr(resource, 'is_smth_public') and resource.is_smth_public():
                publicator.make_one_element_private(
                    uid=item['uid'],
                    rawaddress=address.id
                )
            changed = 1
            
        return changed

    if item:
        found = 0
        changed = 0
        hid = item['hid']
        log.info('item with id: %s found, hid: %s' % (item['_id'], hid))
        for collection in ['user_data', 'trash', 'hidden_data', 'attach_data']:
            for item in db[collection].find({'hid': hid}):
                try:
                    changed += process_one(item, collection)
                except Exception:
                    log.error(traceback.format_exc())
                found += 1
        log.info('%s items found, %s items changed' % (found, changed))
    else:
        print 'cannot find _id "%s" in "%s"' % (options.item_id, options.collection)

if __name__ == "__main__":
    if not options.collection:
        parser.error('specify collection')
    if not options.item_id:
        parser.error('specify _id')
    if not options.value:
        parser.error('specify value')
    run()
