#!/usr/bin/python
# -*- coding: utf-8 -*-


import os
import sys
import cjson
import multiprocessing
import traceback
import commands
import time
from optparse import OptionParser, Option

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
log = mpfs.engine.process.get_default_log()

import mpfs.common.util.config as conf
from mpfs.engine.http.client import open_url
from mpfs.common.util import to_json, from_json, string_converter

config = conf.get('services')
mulca_url = config.get('mulca', 'base_url')
mpfs_url = "http://localhost/json/%(method)s?uid=%(uid)s&path=%(path)s"


def downloader(**kwargs):
    i = kwargs['_id']
    parent = kwargs['parent']
    queue = kwargs['queue']
    while True:
        if os.getppid() != parent:
            log.warn('worker:%s pid:%s parent:%s finished due to parent`s death' % (i, os.getpid(), parent))
            sys.exit(1)
        else:
            path, stid = queue.get()
            try:
                command = 'wget -O ".%s" "%s"' % (path, mulca_url % ('get', stid, ''))
                log.info(command)
                if not options.dry_run:
                    commands.getoutput(command)
            except Exception:
                log.error(traceback.format_exc())

def walk(uid, path, queue):
    paths = [path,]
    command = 'mkdir .%s' % path
    log.info(command)
    if not options.dry_run:
        os.mkdir('.%s' % path)
    while paths:
        path = paths.pop()
        opts = {
                'method' : 'list',
                'path' : path,
                'uid' : uid,
                }
        url = mpfs_url % opts + '&meta=file_mid'
        response = open_url(url, log=log)
        if response is None:
            return None
        folder_list = from_json(response)[1:]
        for element in folder_list:
            try:
                element_path = string_converter(element['path'])
                element_type = element['type']
                if element_type == 'dir':
                    paths.append(element_path)
                    command = 'mkdir .%s' % element_path
                    log.info(command)
                    if not options.dry_run:
                        os.mkdir('.%s' % element_path)
                elif element_type == 'file':
                    queue.put((element_path, string_converter(element['meta']['file_mid'])))
            except Exception:
                log.error(traceback.format_exc())

def main(uid, scopes, pcount):
    workers = []
    queue = multiprocessing.Queue()
    for i in xrange(pcount):
        kwargs = {
            '_id': i,
            'queue': queue,
            'parent': os.getpid(),
        }
        worker_process = multiprocessing.Process(
            target=downloader,
            kwargs=kwargs
        )
        worker_process.start()
        workers.append(worker_process)

    for path in map(lambda x: '/%s' % x.strip(), scopes):
        walk(uid, path, queue)

    while queue.qsize():
        time.sleep(0.1)

    for worker_process in workers:
        worker_process.terminate()


usage = "usage: %prog -h"

option_list = (
    Option(
           '-u', '--uid',
            action='store',
            dest='uid',
            default=False,
           ),
    Option(
           '-o', '--output',
           action='store',
           dest='output',
           default=None,
           help='output folder',
           ),
    Option(
           '-s', '--scopes',
           action='store',
           dest='scopes',
           default=None,
           help='scopes: disk,attach,trash',
           ),
    Option(
           '--pcount',
           action='store',
           type=int,
           dest='pcount',
           default=24,
           help="number of downloaders",
           ),
    Option(
           '--dry-run',
           action='store_true',
           dest='dry_run',
           default=False,
           help="run without action",
           ),
)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

if __name__ == "__main__":
    if options.uid and options.output and options.scopes:
        os.chdir(options.output)
        command_rm = 'rm -R dump_%s' % options.uid
        log.info(command_rm)
        log.info('mkdir ./dump_%s' % options.uid)
        if not options.dry_run:
            commands.getoutput(command_rm)
            os.mkdir('dump_%s' % options.uid)
            os.chdir(options.output + '/dump_%s' % options.uid)
        main(options.uid, options.scopes.split(','), options.pcount)
    else:
        parser.print_help()
        sys.exit(1)
