#!/usr/bin/python
# -*- coding: utf-8 -*-
from optparse import OptionParser, Option

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
log = mpfs.engine.process.get_default_log()

from mpfs.common.util.database.connections import DirectRSConnectionFabric

usage = "usage: %prog -h"

option_list = (
    Option(
        '-o', '--out',
        type='string',
        action='store',
        dest='output_file_name',
        default=False,
        help='File to store uids'
    ),
)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

conn = mpfs.engine.process.dbctl().connection()
dbname = mpfs.engine.process.dbctl().special_config.get('legacy_database', 'dbname')

def iteruids():
    shards = set()
    connection_fabric = DirectRSConnectionFabric()
    for each in list(conn['config']['chunks'].find(
            {'ns': '%s.%s' % (dbname, 'user_index')}, fields=('shard',))):
        shards.add(each['shard'])
    for shard in shards:
        for element in connection_fabric.get_collection_for_rs_name(
                'user_index', shard).find({}, fields=()):
            yield element['_id']


def main(file_name):
    """
    :param file_name:
    """
    with open(file_name, 'wb') as f:
        for uid in iteruids():
            f.write('%s\n' % uid)


if __name__ == "__main__":
    if options.output_file_name:
        main(options.output_file_name)
    else:
        parser.print_help()
