#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

Скрипт увеличения всего

"""
import sys
import pprint
import traceback
from optparse import OptionParser, Option

import mpfs.engine.process

from mpfs.common.util import logger
mpfs.engine.process.setup_admin_script()
log = mpfs.engine.process.get_default_log()

usage = "usage: sudo -u nginx /usr/sbin/%prog -h"

option_list = (
    Option(
        '-u', '--uid',
        action='store',
        dest='uid',
        type='string',
        help='user uid'
    ),
    Option(
        '-p', '--pid',
        action='store',
        dest='pid',
        type='string',
        help='product pid'
    ),
    Option(
        '-a', '--amount',
        action='store',
        dest='amount',
        type='int',
        help='custom amount of space',
        default=None
    ),
    Option(
        '-b', '--btime',
        action='store',
        dest='btime',
        type='int',
        help='custom billing time (unix timestamp)',
        default=None,
    ),
    Option(
        '-f', '--file',
        action='store',
        dest='file',
        type='string',
        help='file with uids, pids, amounts, etc'
    ),
)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

from mpfs.core.billing.client import Client
from mpfs.core.billing.product import Product
from mpfs.core.billing.product.catalog import Catalog
from mpfs.core.billing.market import Market
from mpfs.core.billing.processing import common
from mpfs.common.errors import billing as errors

catalog = Catalog()

def enlarge(uid, pid, amount=None, btime=None):
    mpfs.engine.process.reset_cached()
    service = None
    try:
        client = Client(uid)
        product = Product(pid)
        service = common.simple_create_service(client, product)
        if amount:
            service.set_attribute('product.amount', str(amount))
        if btime:
            service.set_attribute('service.btime', str(btime))
    except errors.BillingProductIsSingletone as e:
        log.info('%s already has %s' % (uid, pid))
        return 'exists'
    except Exception:
        log.error(traceback.format_exc())
        log.error('%s failed with %s' % (uid, pid))
        if service:
            service.delete()
        return 'fail'
    else:
        log.info('%s processed' % uid)
        return 'ok'
    
    
if __name__ == "__main__":
    if not (options.uid and options.pid) and not options.file:
        parser.print_help()
        sys.exit(0)
    
    results = {}

    if options.uid:
        results[options.uid] = enlarge(options.uid, options.pid, options.amount, options.btime)
    elif options.file:
        with open(options.file, 'r') as filedata:
            
            def rpad(length, seq, padding=None):
                return seq + (length - len(seq)) * [ padding ]
            
            for line in filedata:
                values = line.rstrip().split(';')
                uid, pid, amount, btime = rpad(4, values)
                results[uid] = enlarge(uid, pid, amount, btime)
            
    pprint.pprint(results)
    
    
    
    
