#!/usr/bin/python
# -*- coding: utf-8 -*-
import os
import sys
import traceback

from optparse import OptionParser, Option
from pymongo.errors import ConnectionFailure

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
log = mpfs.engine.process.get_default_log()

from mpfs.metastorage.mongo.util import decompress_data
from mpfs.metastorage.mongo.binary import Binary
from mpfs.common.util.database.connections import DirectRSConnectionFabric
from mpfs.metastorage.mongo.collections.filesystem import UserCollectionZipped

DATA_COLLECTIONS = ['user_data', 'attach', 'narod']

connection_fabric = DirectRSConnectionFabric()
user_data_collection = UserCollectionZipped()

option_list = (
    Option(
        '-f', '--hid',
        type='string', action='store',
        dest='hid', help='HID of file',
    ),
    Option(
        '-l', '--limit',
        type='string', action='store',
        dest='limit', help='UID',
        default=10,
    ),
)

usage = "usage: %prog -h HID -l LIMIT"
parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()


def get_short_url(element):
    zdata = decompress_data(element.get('zdata'))
    if zdata:
        return zdata.get('pub', {}).get('short_url')
    else:
        return None


def is_user_blocked(uid):
    spec = {
        '_id': str(uid),
        'blocked': 1
    }
    collection = connection_fabric.get_collection_for_q('user_index', spec)
    return collection.find(spec).count() > 0


def print_short_url_if_exists(hid, type, element):
    short_url = get_short_url(element)

    if short_url is not None:
        if is_user_blocked(element.get('uid')):
            return
        log.info('public link for hid %s : %s' % (hid, short_url))
        print type, short_url


def main(hid, limit):
    for collection_name in DATA_COLLECTIONS:
        spec = {
            'hid': Binary(hid, subtype=2)
        }
        data_collection = connection_fabric.get_collection_for_q(collection_name, spec)

        found = list(data_collection.find(spec, limit=limit))

        parents = []

        for element in found:
            try:
                print_short_url_if_exists(hid, 'file_link', element)

                parents.append(element['parent'])
            except Exception:
                log.error('ERROR: element %s' % element)
                log.error(traceback.format_exc())

        for i in range(1, 10):
            spec = {
                '_id': {
                    '$in': parents
                }
            }
            data_collection = connection_fabric.get_collection_for_q(collection_name, spec)
            parents = []

            for element in list(data_collection.find(spec)):
                try:
                    print_short_url_if_exists(hid, 'folder_link_' + str(i), element)

                    parent = element.get('parent')
                    if parent:
                        parents.append(parent)
                except Exception:
                    log.error('ERROR: element %s' % element)
                    log.error(traceback.format_exc())

if __name__ == '__main__':
    if not options.hid:
        parser.print_help()
        sys.exit(0)
        
    main(options.hid, int(options.limit))
