#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

MPFS

Скрипт для факапов
https://jira.yandex-team.ru/browse/CHEMODAN-11808

"""
import pprint
import itertools
import sys
from optparse import OptionParser, Option

usage = "usage: sudo /usr/sbin/%prog -h"

option_list = (
    Option(
        '-u', '--uid',
        action='store',
        dest='uid',
        type='string',
        help='user id'
    ),
    Option(
        '-f', '--file',
        action='store',
        dest='file',
        type='string',
        help='file with uids (one uid per line)'
    ),
    Option(
       '--dry-run', 
       action='store_true',
       dest='dry_run', 
       default=False,
       help="run without commit",
    ),
)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
log = mpfs.engine.process.get_error_log()

from mpfs.core.billing.processing.repair import repair_services

if __name__ == "__main__":
    if not options.uid and not options.file:
        parser.print_help()
        sys.exit(0)
            
    results = {}
            
    if options.uid:
        results[options.uid] = repair_services(options.uid, dry_run=options.dry_run)
    elif options.file:
        with open(options.file, 'r') as uids:
            for uid in itertools.ifilter(None, itertools.imap(lambda l: l.rstrip(), uids.readlines())):
                results[uid] = repair_services(uid, dry_run=options.dry_run)
                
    pprint.pprint(results)