#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
Легендарный mpfs-fsck в новом виде
Пока функциональность невелика, но зато оно работает!
"""
import sys
import traceback

from optparse import OptionParser, Option

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()

from mpfs.core.filesystem.repair.hierarchy import HierarchyRepairTool
from mpfs.core.filesystem.repair.hidden import HiddenDataUnzipTool

error_log = mpfs.engine.process.get_error_log()

TOOLS = {
    'hierarchy': HierarchyRepairTool,
    'hidden': HiddenDataUnzipTool,
}

option_list = (
    Option(
        '-u', '--uid',
        action='store',
        dest='uid',
        type='string',
        help='user uid'
    ),
    Option(
        '-c', '--collection',
        action='store',
        dest='collection',
        type='string',
        help='collection name'
    ),
    Option(
        '-t', '--tool',
        action='store',
        dest='tool',
        type='string',
        help='tool to use: [%s]' % '|'.join(TOOLS.keys())
    ),
    Option(
        '--dry',
        action='store_true',
        dest='dry',
        help='dry mode (False by default)',
        default=False,
    ),
    Option(
        '--verbose',
        action='store_true',
        dest='verbose',
        help='verbose everything (False by default)',
        default=False,
    ),
)

usage = "usage: sudo /usr/sbin/%prog -h"
parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()


def main():
    tool = TOOLS[options.tool](verbose=options.verbose)
    if options.dry:
        tool.report(options.uid, options.collection)
    else:
        tool.repair(options.uid, options.collection)


if __name__ == "__main__": 
    if not options.uid and not options.tool or options.tool not in TOOLS:
        parser.print_help()
        sys.exit(0)
    try:
        main()
        sys.exit(0)
    except Exception as e:
        error_log.error(traceback.format_exc())
        sys.exit(1)