#!/usr/bin/python
# -*- coding: utf-8 -*-
import sys

from optparse import OptionParser, Option

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()

from mpfs.core.filesystem.base import Filesystem
from mpfs.common.util import format_dict_table, human_size
from mpfs.core.services.disk_service import MPFSStorageService

''' ================================== Snippets ======================================= '''

class MyOption(Option):

    ACTIONS = Option.ACTIONS + ("extend",)
    STORE_ACTIONS = Option.STORE_ACTIONS + ("extend",)
    TYPED_ACTIONS = Option.TYPED_ACTIONS + ("extend",)
    ALWAYS_TYPED_ACTIONS = Option.ALWAYS_TYPED_ACTIONS + ("extend",)

    def take_action(self, action, dest, opt, value, values, parser):
        if action == "extend":
            lvalue = value.split(",")
            values.ensure_value(dest, []).extend(lvalue)
        else:
            Option.take_action(
                self, action, dest, opt, value, values, parser)

''' =================================================================================== '''


usage = "usage: sudo -u nginx /usr/sbin/%prog -h"

option_list = (
    Option(
        '-m', '--mode',
        action='store',
        type='string',
        dest='mode',
        metavar='MODE',
        default='space',
        help='interaction mode: space, [default: %default]'
    ),
    Option(
        '--show',
        action='store_false',
        dest='set_value',
        help='show values, [default: True]'
    ),
    Option(
        '--set-limit',
        action='store',
        type='int',
        dest='set_limit',
        metavar='LIMIT',
        help='set disk limit value in bytes'
    ),
    MyOption(
        '-u', '--uid',
        action='store',
        dest='uid',
        type='string',
        help='user id, 123 or 123,124,125',
    ),
    Option(
        '-i', '--inspect',
        action='store_true',
        dest='inspect',
        default=False,
        help='Inspect all counters: update values, [default: %default]'
    ),
    Option(
        '-H', '--human',
        action='store_true',
        dest='human',
        default=False,
        help='"Human-readable" output'
    ),
)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

fs = Filesystem()


class Space(object):

    def show(self, uids=None):
        if not uids:
            uids = options.uid.split(',')
        column_names = ('uid', 'files_count', 'limit', 'used', 'free', 'trash')

        if options.inspect:
            _do = fs.quota.inspect
        else:
            _do = fs.quota.report

        data = []
        for uid in uids:
            data.append(_do(uid))

        if options.human:
            for item in data:
                for _k in ('limit', 'used', 'free', 'trash'):
                    item[_k] = human_size(item[_k])

        print format_dict_table(data, column_names)

    def set_limit(self):
        val = int(options.set_limit)
        uids = options.uid.split(',')
        print 'Old:'
        self.show(uids=uids)
        for uid in uids:
            fs.quota.set_limit(val, uid=uid)
        print 'New:'
        self.show(uids=uids)


cmds = {'space': Space}


if __name__ == "__main__":
    if not options.uid:
        parser.print_help()
        sys.exit(0)
        
    try:
        cmd_class = cmds[options.mode]
    except KeyError:
        parser.error('Unknown mode=%s' % options.mode)
    except AttributeError:
        parser.print_help()
    else:
        if options.set_limit:
            cmd_class().set_limit()
        else:
            cmd_class().show()

