#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Это админский скрипт, который делает следующее:
    1. Используя ``Kladun``, генерит новый ``pmid`` для определенного ``address``.
    2. Удаляет ``stid``-ы из ``previews`` и сохраняет удаленные в ``deleted_stids``.

Пример использования::
    python mpfs-admin-previews-manager.py --address "4000756161:/disk/11_22.JPG"

Скрипт должен запускаться из-под ``sudo``.

TODO:
    Сделать обновление превью у всех хардликов по хиду.

    В момоент написания это сделать было невозможно, т.к. невозможно учесть миграцию ресурсов с монгоса на шарды.
    Появилась такая ситуация, что ресурс уже был перенесен из монгоса в шард, а удалить его из монгоса забыли.
    Просто отфильтровать его нельзя, т.к. на него может захардлинкаться другой файл.

"""
from argparse import ArgumentParser

from mpfs.engine.process import setup_admin_script
# Call before other imports
setup_admin_script()

from mpfs.core import factory
from mpfs.core.address import Address
from mpfs.core.filesystem.resources.disk import MPFSFile


def regenerate_preview(raw_address, dry_run=True):
    address = Address(raw_address)
    resource = factory.get_resource(address.uid, address)
    if not isinstance(resource, MPFSFile):
        raise TypeError('Cant regenerate preview for %s' % resource.__class__.__name__)
    if not dry_run:
        resource.regenerate_preview()


if __name__ == '__main__':
    parser = ArgumentParser(description='Fix invalid previews')
    parser.add_argument('-d', '--dry-run', action='store_true', help='Do not make any changes')
    parser.add_argument('address', nargs=1, type=str, help="File's address like 'uid:path'")
    args = parser.parse_args()

    raw_address = args.address[0].decode('utf-8')
    regenerate_preview(raw_address, dry_run=args.dry_run)
