#!/usr/bin/python
# -*- coding: utf-8 -*-
from optparse import OptionParser, Option

usage = "usage: sudo /usr/sbin/%prog -h"
    
option_list = (
    Option(
        '--hash',
        action='store',
        dest='hash',
        type='string',
        default=None,
        help='Specify public hash'
    ),
)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()

from mpfs.core.social.publicator import Publicator
import json

def resolve_public():
    item = Publicator().public_info(options.hash)
    print json.dumps(item, ensure_ascii=False, sort_keys=True, indent=4).encode('utf-8')

if __name__ == "__main__":
    if not options.hash:
        parser.print_help()
        sys.exit(0)
    else:
        resolve_public()
