#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import operator
from optparse import OptionParser, Option
from time import ctime
import traceback

class MyOption(Option):

    ACTIONS = Option.ACTIONS + ("extend",)
    STORE_ACTIONS = Option.STORE_ACTIONS + ("extend",)
    TYPED_ACTIONS = Option.TYPED_ACTIONS + ("extend",)
    ALWAYS_TYPED_ACTIONS = Option.ALWAYS_TYPED_ACTIONS + ("extend",)

    def take_action(self, action, dest, opt, value, values, parser):
        if action == "extend":
            lvalue = value.split(",")
            values.ensure_value(dest, []).extend(lvalue)
        else:
            Option.take_action(
                self, action, dest, opt, value, values, parser)


usage = "usage: sudo %prog -h [< in_data.file]"

option_list = (
    Option(
        '-m', '--mode',
        action='store',
        type='string',
        dest='mode',
        metavar='MODE',
        default='show',
        help='interaction mode: show, restore; [default: %default]'),
    Option(
        '-f', '--file',
        action='store',
        type='string',
        dest='file_id',
        metavar='FILE_ID',
        help='what to restore'),
    Option(
        '-d', '--dest',
        action='store',
        type='string',
        dest='parent_id',
        metavar='FILE_ID', default='/disk/',
        help='where resource will be placed'),
    MyOption(
        '-u', '--uid',
        action='store',
        dest='uid',
        type='string',
        help='user id, 123 or 123,124,125'),
    Option(
        '-H', '--human',
        action='store_true',
        dest='human',
        default=False,
        help='"Human-readable" output'),
    )

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()

from mpfs.core.filesystem.base import Filesystem
from mpfs.common.util import format_dict_table, human_size
from mpfs.core.address import Address
from mpfs.common import errors

db = mpfs.engine.process.dbctl().database()

def restore():
    uid = uids[0]
    if not options.file_id:
        parser.error('Specify file id')
        sys.exit(1)
    try:
        rows = []
        if '/' not in options.file_id:
            element = db.hidden_data.find_one({'uid' : str(uid), '_id' : options.file_id}, fields=('key', ))
            if element:
                key = element['key']
            else:
                print 'not found {_id: %s, uid: %s}' % (options.file_id, uid)
                sys.exit()
        else:
            key = options.file_id
        mpfs.engine.process.reset_cached()
        data = Filesystem().restore_deleted(
            str(uid),
            Address.Make(uid, key).id,
            Address.Make(uid, options.parent_id).id)
        for k, v in filter(lambda (k, v): v['type'] == 'file', data.iteritems()):
            v['id'] = k
            v['size'] = human_size(v['size'])
            v['creation_time'] = ctime(float(v['ctime']))
            rows.append(v)
        print format_dict_table(rows, ('uid', 'id', 'size', 'creation_time'))
    except errors.ResourceNotFound:
        print "%s not found" % options.file_id
    except Exception:
        print "%s failed" % uid
        print traceback.format_exc()


def show():
    if options.human:
        rows = []
        for uid in uids:
            column_names = ('uid', 'name', 'size', 'deleted')
            mpfs.engine.process.reset_cached()
            resource = Filesystem().resource(uid, Address.Make(uid, '/hidden').id)
            data = resource.get_full_index()
            for k, v in filter(lambda (k, v): v['type'] == 'file', data.iteritems()):
                v['id'] = k
                v['size'] = human_size(v['size'])
                v['deleted'] = ctime(v['dtime'])
                v['name'] = ':'.join(k.split('/').pop().split(':')[:-1])
                rows.append(v)
        print format_dict_table(rows, column_names)
    else:
        keys = ('uid', 'key', 'dtime')
        fields = ('type', ) + keys
        for uid in uids:
            for element in db.hidden_data.find({'uid' : str(uid)}, fields=fields):
                if element['type'] != 'file':
                    continue
                else:
                    print '%s, %s, "%s", %s' % tuple(map(lambda k: normalize_unicode(element[k]), ('uid', '_id', 'key', 'dtime')))


def normalize_unicode(s):
    if isinstance(s, unicode):
        try:
            s = s.encode('utf-8')
        except Exception:
            s = s.encode('raw_unicode_escape')
    return s

uid = []

if __name__ == "__main__":
    if len(sys.argv) == 1:
        parser.print_help()
        sys.exit(1)
    
    uids = map(int, options.uid.split(',') if options.uid else map(operator.methodcaller('rstrip'), sys.stdin.readlines()))
    if not uids:
        parser.error('Empty uid')
        sys.exit(1)

    try:     
        cmd = globals()[options.mode]
    except KeyError:
        parser.error('Unknown mode=%s' % options.mode)
    except AttributeError:
        parser.print_help()
    else:
        cmd()
