#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

Скрипт для сбора новых пользователей (за последний месяц или более) и
пользователей с продленной услугой (за тот же период).

"""
import sys
import time

from optparse import OptionParser, Option
from datetime import datetime
from dateutil.relativedelta import relativedelta

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()

from mpfs.core.metastorage.control import billing_services
from mpfs.common.static import tags


db = mpfs.engine.process.dbctl().database()
log = mpfs.engine.process.get_error_log()


usage = "usage:" \
        "\t%prog -h\n" \
        "\t%prog --new\n" \
        "\t%prog --prolongated\n" \
        "\t%prog --prolongated --last-time-check=2015-05-01"

option_list = (
    Option(
        '--new',
        action='store_true',
        dest='new',
        help='dump new uids (since last-time-check)',
        default=False
    ),
    Option(
        '--prolongated',
        action='store_true',
        dest='prolongated',
        help='dump prolongated uids (since last-time-check)',
        default=False
    ),
    Option(
        '--last-check-time',
        action='store',
        type='string',
        dest='last_check_time',
        help='time since the service creation time is counted (default value is now), format is YYYY-MM-DD',
        default=None
    ),
    Option(
        '--without-header',
        action='store_false',
        dest='write_header',
        help='do not write csv header to stdout',
        default=True
    ),
    Option(
        '-s', '--separator',
        action='store',
        type='string',
        dest='separator',
        help='symbol to separate output values',
        default=','
    )
)


def dump_rostelecom_users(last_check_time, dump_new_users, dump_prolongated_users, write_header, separator):
    last_check_ts = int(time.mktime(last_check_time.timetuple()))

    queries = []
    query = {'pid': 'rostelecom_2015_100gb_paid'}

    if dump_new_users:
        # {'pid': 'rostelecom_2015_100gb_paid', 'ctime': {'$gte': last_check_ts}}
        q = query.copy()
        q[tags.billing.CTIME] = {'$gte': last_check_ts}
        queries.append(q)

    if dump_prolongated_users:
        # {'pid': 'rostelecom_2015_100gb_paid', 'ctime': {'$lt': last_check_ts}, 'mtime': {'$gte': last_check_ts}}
        q = query.copy()
        q[tags.billing.CTIME] = {'$lt': last_check_ts}
        q[tags.billing.MTIME] = {'$gte': last_check_ts}
        queries.append(q)

    query = {'$or': queries}
    result = billing_services.find(query)

    if write_header:
        print separator.join(['uid', 'creation date', 'expiration date'])

    for doc in result:
        datetime_format = '%Y-%m-%dT%H:%M:%S'
        ctime = datetime.utcfromtimestamp(doc[tags.billing.CTIME])
        btime = datetime.utcfromtimestamp(doc[tags.billing.BTIME])

        print separator.join([doc[tags.billing.UID], ctime.strftime(datetime_format), btime.strftime(datetime_format)])


if __name__ == "__main__":
    parser = OptionParser(usage, option_list=option_list)
    (options, args) = parser.parse_args()

    if not options.new and not options.prolongated:
        sys.stderr.write('Option --new or --prolongated (or both) must be specified\n\n')
        parser.print_help()
        sys.exit(2)

    if not options.last_check_time:
        last_check_time = datetime.utcnow() - relativedelta(months=1)
    else:
        try:
            last_check_time = datetime.strptime(options.last_check_time, '%Y-%m-%d')
        except ValueError as e:
            sys.stderr.write('Date format error: %s\n' % e.message)
            sys.exit(2)

    dump_rostelecom_users(last_check_time, options.new, options.prolongated, options.write_header, options.separator)
