#!/usr/bin/python
# -*- coding: utf-8 -*-
import os
import cjson
os.environ['MPFS_PACKAGE'] = 'disk'

from optparse import OptionParser, Option

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()

from mpfs.common.util import mailer
from mpfs.core.user.base import User
from mpfs.core.services.passport_service import Passport

usage = "usage: sudo /usr/sbin/%prog -h"

option_list = (
    Option(
        '-a', '--address',
        action='store',
        dest='address',
        type='string',
        help='Specify address'
    ),
    Option(
        '-u', '--uid',
        action='store',
        dest='uid',
        type='string',
        help='Specify uid'
    ),
    Option(
        '-t', '--template',
        action='store',
        dest='template',
        type='string',
        help='Template, see /etc/mpfs/templates/',
    ),
    Option(
        '-l', '--locale',
        action='store',
        dest='locale',
        type='string',
        default='ru',
        help='Locale: ru, en, tr, uk',
    ),
    Option(
        '-p', '--params',
        action='store',
        dest='params',
        type='string',
        default='{}',
        help='All the data that template needs, in dict {}'
    )
)

passport = Passport()
parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()


class Mailer(object):

    def __init__(self, options):
        self.options = options
        self.args = cjson.decode(self.options.params)
        if options.address:
            self.args['locale']  = options.locale
            self.args['address'] = options.address
        elif options.uid:
            user = User(options.uid)
            userinfo = passport.userinfo(options.uid, all_emails=True)
            self.args['address'] = userinfo.get('email')
            self.args['locale']  = userinfo.get('language')
            for k,v in userinfo.iteritems():
                self.args[k] = self.args.get(k, v)
        
    def send(self):
        template = options.template
        required_args = mailer.template_args(template)
        
        def check_missed_arg(key):
            chunks = key.split('.')
            if len(chunks) > 1:
                return self.args.get(chunks[0], {}).get(chunks[1], False) == False
            else:
                return self.args.get(chunks[0], False) == False
        
        missed_args = filter(check_missed_arg, required_args)
        
        if len(missed_args) > 0:
            print "specify args: %s" % missed_args
        else:
            address = self.args.pop('address')
            mailer.send(address, template, self.args)


if __name__ == "__main__":
    if not options.address and not options.uid:
        parser.error('specify address')
    if not options.template:
        parser.error('specify template')
    Mailer(options).send()
