# -*- coding: utf-8 -*-

import argparse
import calendar
import datetime

import mpfs.engine.process
from mpfs.engine.process import setup_anyone_script
setup_anyone_script()


DEFAULT_CTIME = calendar.timegm(datetime.datetime(year=2012, month=1, day=1).timetuple())


def find_invite(group_invites_collection, gid, universe_login, universe_service, uid):
    invite = None
    if universe_login and universe_service:
        invite = group_invites_collection.find_one(
            {
                'universe_login': universe_login,
                'universe_service': universe_service,
                'gid': gid
            }
        )

    if uid and not invite:
        return group_invites_collection.find_one(
            {
                'uid': uid,
                'gid': gid
            }
        )

    return invite


def main(dry_run=True, verbose=True):
    print 'Dry run: %s' % dry_run
    print 'DEFAULT_CTIME: %s' % DEFAULT_CTIME
    missing_invites_cnt = 0
    invites_cnt = 0
    conn = mpfs.engine.process.dbctl().connection('common')
    try:
        group_links_collection = conn['group_links']['group_links']
        group_invites_collection = conn['group_invites']['group_invites']
        for group_link in group_links_collection.find(
            {'ctime': {'$exists': False}},
            fields=['universe_login', 'universe_service', 'uid', 'gid', '_id']
        ):

            universe_login = group_link.get('universe_login')
            universe_service = group_link.get('universe_service')
            uid = group_link.get('uid')
            gid = group_link['gid']

            invite = find_invite(group_invites_collection, gid, universe_login, universe_service, uid)
            ctime = DEFAULT_CTIME
            if not invite:
                missing_invites_cnt += 1
                if verbose:
                    print 'Could not find corresponding invite for link %s' % group_link['_id']
            else:
                invites_cnt += 1
                if verbose:
                    print 'Found corresponding invite for link %s --> %s' % (group_link['_id'], invite['_id'])
                ctime = invite['ctime']

            if not dry_run:
                group_links_collection.update({'_id': group_link['_id']}, {'$set': {'ctime': ctime}})

    except Exception as e:
        print 'Unexpected error: %s' % e.message
    finally:
        print 'Not found corresponding invite: %s' % missing_invites_cnt
        print 'Found corresponding invite: %s' % invites_cnt


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description=__doc__)
    parser.add_argument('--dry-run', dest='dry_run', action='store_true', help='Dry run mode.')
    parser.add_argument('--no-dry-run', dest='dry_run', action='store_false')
    parser.set_defaults(dry_run=True)
    parser.add_argument('-v', dest='verbose', action='store_true', default=True, help='Verbose mode.')
    args = parser.parse_args()
    kwargs = vars(args)
    main(**kwargs)
